/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.util.IOHelper;

public class ByteArrayInputStreamCache
extends FilterInputStream
implements StreamCache {
    private final ByteArrayInputStream bais;
    private final int length;
    private byte[] byteArrayForCopy;

    public ByteArrayInputStreamCache(ByteArrayInputStream in) {
        super(in);
        this.bais = in;
        this.length = in.available();
    }

    @Override
    public synchronized void reset() {
        try {
            super.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        IOHelper.copyAndCloseInput((InputStream)this.in, (OutputStream)os);
    }

    public StreamCache copy(Exchange exchange) throws IOException {
        if (this.byteArrayForCopy == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.in.available());
            IOHelper.copy((InputStream)this.in, (OutputStream)baos);
            this.reset();
            this.byteArrayForCopy = baos.toByteArray();
        }
        return new InputStreamCache(this.byteArrayForCopy);
    }

    public boolean inMemory() {
        return true;
    }

    public long length() {
        return this.length;
    }

    public long position() {
        return this.length - this.bais.available();
    }
}

