/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.annotations.EagerClassloaded;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EagerClassloaded
public final class UnitOfWorkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkHelper.class);

    private UnitOfWorkHelper() {
    }

    public static void onClassloaded(Logger log) {
        log.trace("Loaded UnitOfWorkHelper");
    }

    public static void doneUow(UnitOfWork uow, Exchange exchange) {
        if (uow == null) {
            return;
        }
        try {
            uow.done(exchange);
            if (uow instanceof Service) {
                ServiceHelper.stopService((Object)uow);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: {}. This exception will be ignored.", (Object)exchange, (Object)e);
        }
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        if (synchronizations == null || synchronizations.isEmpty()) {
            return;
        }
        if (synchronizations.size() > 1) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            copy.sort(OrderedComparator.get());
            boolean failed = exchange.isFailed();
            for (Synchronization synchronization : copy) {
                UnitOfWorkHelper.doneSynchronization(synchronization, exchange, failed);
            }
        } else {
            UnitOfWorkHelper.doneSynchronization(synchronizations.get(0), exchange, exchange.isFailed());
        }
    }

    private static void doneSynchronization(Synchronization synchronization, Exchange exchange, boolean failed) {
        try {
            if (failed) {
                LOG.trace("Invoking synchronization.onFailure: {} with {}", (Object)synchronization, (Object)exchange);
                synchronization.onFailure(exchange);
            } else {
                LOG.trace("Invoking synchronization.onComplete: {} with {}", (Object)synchronization, (Object)exchange);
                synchronization.onComplete(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during onCompletion. This exception will be ignored.", e);
        }
    }

    public static void beforeRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
        Collections.reverse(copy);
        copy.sort(OrderedComparator.get());
        for (Synchronization synchronization : copy) {
            if (!(synchronization instanceof SynchronizationRouteAware)) continue;
            try {
                log.trace("Invoking synchronization.onBeforeRoute: {} with {}", (Object)synchronization, (Object)exchange);
                ((SynchronizationRouteAware)synchronization).onBeforeRoute(route, exchange);
            }
            catch (Throwable e) {
                log.warn("Exception occurred during onBeforeRoute. This exception will be ignored.", e);
            }
        }
    }

    public static void afterRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
        Collections.reverse(copy);
        copy.sort(OrderedComparator.get());
        for (Synchronization synchronization : copy) {
            if (!(synchronization instanceof SynchronizationRouteAware)) continue;
            try {
                log.trace("Invoking synchronization.onAfterRoute: {} with {}", (Object)synchronization, (Object)exchange);
                ((SynchronizationRouteAware)synchronization).onAfterRoute(route, exchange);
            }
            catch (Throwable e) {
                log.warn("Exception occurred during onAfterRoute. This exception will be ignored.", e);
            }
        }
    }
}

