/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public final class JsonUtils {
    static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static String convertMapToJson(Map<String, Object> inputMap) {
        try {
            return MAPPER.writeValueAsString(inputMap);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("Error occurred writing data map to JSON.", exception);
        }
    }

    public static Map<String, Object> convertJsonToMap(String jsonString) {
        try {
            return (Map)MAPPER.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("Error occurred writing JSON to Map.", exception);
        }
    }
}

