/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.dataformat.ArtixDSDataFormat;
import org.apache.camel.model.dataformat.DataFormatDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.StickyLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.TopicLoadBalanceStrategy;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelJMXAgentDefinition;
import org.apache.camel.spring.CamelTemplateFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.spring.handler.ScriptDefinitionParser;
import org.apache.camel.spring.remoting.CamelProxyFactoryBean;
import org.apache.camel.spring.remoting.CamelServiceExporter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.ModelFileGenerator;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    protected BeanDefinitionParser endpointParser = new BeanDefinitionParser(EndpointFactoryBean.class);
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class);
    protected Set<String> parserElementNames = new HashSet<String>();
    protected Binder<Node> binder;
    private JAXBContext jaxbContext;
    private Map<String, BeanDefinitionParser> parserMap = new HashMap<String, BeanDefinitionParser>();

    public ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return new ModelFileGenerator(this.getJaxbContext());
    }

    public void init() {
        this.addBeanDefinitionParser("proxy", CamelProxyFactoryBean.class);
        this.addBeanDefinitionParser("template", CamelTemplateFactoryBean.class);
        this.addBeanDefinitionParser("export", CamelServiceExporter.class);
        this.addBeanDefinitionParser("artixDS", ArtixDSDataFormat.class);
        this.addBeanDefinitionParser("jaxb", JaxbDataFormat.class);
        this.addBeanDefinitionParser("serialization", SerializationDataFormat.class);
        this.addBeanDefinitionParser("xmlBeans", XMLBeansDataFormat.class);
        this.addBeanDefinitionParser("roundRobin", RoundRobinLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("random", RandomLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("sticky", StickyLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("topic", TopicLoadBalanceStrategy.class);
        this.addBeanDefinitionParser("jmxAgent", CamelJMXAgentDefinition.class);
        this.addBeanDefinitionParser("endpoint", EndpointFactoryBean.class);
        Class cl = CamelContextFactoryBean.class;
        try {
            cl = Class.forName("org.apache.camel.osgi.CamelContextFactoryBean");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerParser("camelContext", (org.springframework.beans.factory.xml.BeanDefinitionParser)new CamelContextBeanDefinitionParser(cl));
    }

    private void addBeanDefinitionParser(String elementName, Class<?> type) {
        BeanDefinitionParser parser = new BeanDefinitionParser(type);
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)parser);
        this.parserMap.put(elementName, parser);
    }

    protected void createBeanPostProcessor(ParserContext parserContext, String contextId, Element childElement, BeanDefinitionBuilder parentBuilder) {
        String beanPostProcessorId = contextId + ":beanPostProcessor";
        childElement.setAttribute("id", beanPostProcessorId);
        BeanDefinition definition = this.beanPostProcessorParser.parse(childElement, parserContext);
        definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
        parentBuilder.addPropertyReference("beanPostProcessor", beanPostProcessorId);
    }

    protected void registerScriptParser(String elementName, String engineName) {
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)new ScriptDefinitionParser(engineName));
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    public Set<String> getParserElementNames() {
        return this.parserElementNames;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext) {
        try {
            this.binder = this.getJaxbContext().createBinder();
            return this.binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new BeanDefinitionStoreException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        StringBuilder packages = new StringBuilder();
        for (Class cl : this.getJaxbPackages()) {
            if (packages.length() > 0) {
                packages.append(":");
            }
            packages.append(cl.getName().substring(0, cl.getName().lastIndexOf(46)));
        }
        return JAXBContext.newInstance((String)packages.toString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    protected Set<Class> getJaxbPackages() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(CamelContextFactoryBean.class);
        classes.add(ExchangePattern.class);
        classes.add(RouteDefinition.class);
        classes.add(StreamResequencerConfig.class);
        classes.add(DataFormatDefinition.class);
        classes.add(ExpressionDefinition.class);
        classes.add(LoadBalancerDefinition.class);
        return classes;
    }

    protected void injectNamespaces(Element element) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = this.binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement);
        }
    }

    protected void registerEndpointsWithIdsDefinedInFromToTypes(Element element, ParserContext parserContext, String contextId) {
        NodeList list = element.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = this.binder.getJAXBNode((Object)child);
            if (object instanceof FromDefinition || object instanceof SendDefinition) {
                this.registerEndpoint(childElement, parserContext, contextId);
            }
            this.registerEndpointsWithIdsDefinedInFromToTypes(childElement, parserContext, contextId);
        }
    }

    private void registerEndpoint(Element childElement, ParserContext parserContext, String contextId) {
        String id = childElement.getAttribute("id");
        if (ObjectHelper.isNotEmpty((Object)id)) {
            BeanDefinition definition = this.endpointParser.parse(childElement, parserContext);
            definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
        }
    }

    protected class CamelContextBeanDefinitionParser
    extends BeanDefinitionParser {
        public CamelContextBeanDefinitionParser(Class type) {
            super(type);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Object value;
            super.doParse(element, parserContext, builder);
            String contextId = element.getAttribute("id");
            if (ObjectHelper.isEmpty((Object)contextId)) {
                contextId = "camelContext";
                element.setAttribute("id", contextId);
            }
            if ((value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext)) instanceof CamelContextFactoryBean) {
                CamelContextFactoryBean factoryBean = (CamelContextFactoryBean)((Object)value);
                builder.addPropertyValue("id", (Object)contextId);
                builder.addPropertyValue("routes", factoryBean.getRoutes());
                builder.addPropertyValue("intercepts", factoryBean.getIntercepts());
                builder.addPropertyValue("dataFormats", (Object)factoryBean.getDataFormats());
                builder.addPropertyValue("exceptionClauses", factoryBean.getExceptionClauses());
                builder.addPropertyValue("builderRefs", factoryBean.getBuilderRefs());
                builder.addPropertyValue("properties", (Object)factoryBean.getProperties());
                if (factoryBean.getPackages().length > 0) {
                    builder.addPropertyValue("packages", (Object)factoryBean.getPackages());
                }
            }
            boolean createdBeanPostProcessor = false;
            NodeList list = element.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (localName.equals("beanPostProcessor")) {
                    CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement, builder);
                    createdBeanPostProcessor = true;
                    continue;
                }
                if (localName.equals("endpoint")) {
                    CamelNamespaceHandler.this.registerEndpoint(childElement, parserContext, contextId);
                    continue;
                }
                BeanDefinitionParser parser = (BeanDefinitionParser)((Object)CamelNamespaceHandler.this.parserMap.get(localName));
                if (parser == null) continue;
                BeanDefinition definition = parser.parse(childElement, parserContext);
                String id = childElement.getAttribute("id");
                if (!ObjectHelper.isNotEmpty((Object)id)) continue;
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                if (!localName.equals("jmxAgent")) continue;
                builder.addPropertyReference("camelJMXAgent", id);
            }
            CamelNamespaceHandler.this.registerEndpointsWithIdsDefinedInFromToTypes(element, parserContext, contextId);
            CamelNamespaceHandler.this.injectNamespaces(element);
            if (!createdBeanPostProcessor) {
                Element childElement = element.getOwnerDocument().createElement("beanPostProcessor");
                element.appendChild(childElement);
                CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement, builder);
            }
        }
    }
}

