/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.ProxyHelper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class CamelProxyFactoryBean
extends UrlBasedRemoteAccessor
implements FactoryBean,
CamelContextAware,
DisposableBean {
    private CamelContext camelContext;
    private Endpoint endpoint;
    private Object serviceProxy;
    private Producer producer;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            if (this.endpoint == null) {
                if (this.getServiceUrl() == null || this.camelContext == null) {
                    throw new IllegalArgumentException("If endpoint is not specified, the serviceUrl and camelContext must be specified.");
                }
                this.endpoint = this.camelContext.getEndpoint(this.getServiceUrl());
                if (this.endpoint == null) {
                    throw new IllegalArgumentException("Could not resolve endpoint: " + this.getServiceUrl());
                }
            }
            this.producer = this.endpoint.createProducer();
            this.producer.start();
            this.serviceProxy = ProxyHelper.createProxy((Endpoint)this.endpoint, (Producer)this.producer, (Class[])new Class[]{this.getServiceInterface()});
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void destroy() throws Exception {
        this.producer.stop();
        this.producer = null;
        this.serviceProxy = null;
    }

    public Class getServiceInterface() {
        return super.getServiceInterface();
    }

    public String getServiceUrl() {
        return super.getServiceUrl();
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

