/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable {
    private static final Log LOG = LogFactory.getLog(SedaConsumer.class);
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private Thread thread;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorTypeConverter.convert((Processor)processor);
    }

    public String toString() {
        return "SedaConsumer: " + this.endpoint.getEndpointUri();
    }

    public void run() {
        while (this.isRunAllowed()) {
            Exchange exchange;
            try {
                exchange = this.endpoint.getQueue().poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                break;
            }
            if (exchange == null || !this.isRunAllowed()) continue;
            this.processor.process(exchange, new AsyncCallback(){

                public void done(boolean sync) {
                }
            });
        }
    }

    protected void doStart() throws Exception {
        this.thread = new Thread((Runnable)this, this.getThreadName(this.endpoint.getEndpointUri()));
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void doStop() throws Exception {
        this.thread.join();
    }
}

