/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private Class type;
    private Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private Expression parametersExpression;

    public MethodInfo(Class type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation) {
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.parametersExpression = this.createParametersExpression();
    }

    public String toString() {
        return this.method.toString();
    }

    public MethodInvocation createMethodInvocation(final Object pojo, final Exchange messageExchange) {
        final Object[] arguments = (Object[])this.parametersExpression.evaluate(messageExchange);
        return new MethodInvocation(){

            public Method getMethod() {
                return MethodInfo.this.method;
            }

            public Object[] getArguments() {
                return arguments;
            }

            public Object proceed() throws Throwable {
                return MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, messageExchange);
            }

            public Object getThis() {
                return pojo;
            }

            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    public Class getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class getBodyParameterType() {
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class bodyType) {
        Class actualType = this.getBodyParameterType();
        return actualType != null && ObjectHelper.isAssignableFrom((Class)bodyType, (Class)actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean isHasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws IllegalAccessException, InvocationTargetException {
        return mth.invoke(pojo, arguments);
    }

    protected Expression createParametersExpression() {
        final int size = this.parameters.size();
        final Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
        }
        return new Expression<Exchange>(){

            public Object evaluate(Exchange exchange) {
                Object[] answer = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object value = expressions[i].evaluate(exchange);
                    answer[i] = value = ExchangeHelper.convertToType((Exchange)exchange, (Class)((ParameterInfo)MethodInfo.this.parameters.get(i)).getType(), (Object)value);
                }
                return answer;
            }

            public String toString() {
                return "ParametersExpression: " + Arrays.asList(expressions);
            }
        };
    }
}

