/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.impl.engine.DefaultCamelBeanPostProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

@Metadata(label="spring,configuration")
@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements org.apache.camel.spi.CamelBeanPostProcessor,
BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelBeanPostProcessor.class);
    @XmlTransient
    Set<String> prototypeBeans = new LinkedHashSet<String>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private String camelId;
    @XmlTransient
    private boolean bindToRegistrySupported;
    @XmlTransient
    private final DefaultCamelBeanPostProcessor delegate = new DefaultCamelBeanPostProcessor(){

        public CamelContext getOrLookupCamelContext() {
            if (this.camelContext == null) {
                if (CamelBeanPostProcessor.this.camelId != null) {
                    LOG.trace("Looking up CamelContext by id: {} from Spring ApplicationContext: {}", (Object)CamelBeanPostProcessor.this.camelId, (Object)CamelBeanPostProcessor.this.applicationContext);
                    this.camelContext = (CamelContext)CamelBeanPostProcessor.this.applicationContext.getBean(CamelBeanPostProcessor.this.camelId, CamelContext.class);
                } else {
                    LOG.trace("Looking up CamelContext by type from Spring ApplicationContext: {}", (Object)CamelBeanPostProcessor.this.applicationContext);
                    Map contexts = CamelBeanPostProcessor.this.applicationContext.getBeansOfType(CamelContext.class);
                    if (contexts != null && contexts.size() == 1) {
                        this.camelContext = (CamelContext)contexts.values().iterator().next();
                    }
                }
            }
            return this.camelContext;
        }

        public boolean canPostProcessBean(Object bean, String beanName) {
            if (bean == null || bean instanceof CamelJMXAgentDefinition) {
                return false;
            }
            return super.canPostProcessBean(bean, beanName);
        }

        protected boolean bindToRegistrySupported() {
            return false;
        }

        public CamelPostProcessorHelper getPostProcessorHelper() {
            if (this.camelPostProcessorHelper == null) {
                this.camelPostProcessorHelper = new CamelPostProcessorHelper(){

                    public CamelContext getCamelContext() {
                        return CamelBeanPostProcessor.this.delegate.getOrLookupCamelContext();
                    }

                    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
                        return new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + endpoint, (Throwable)e);
                    }

                    protected boolean isSingleton(Object bean, String beanName) {
                        if (CamelBeanPostProcessor.this.applicationContext == null || beanName == null) {
                            return super.isSingleton(bean, beanName);
                        }
                        return CamelBeanPostProcessor.this.applicationContext.isSingleton(beanName);
                    }

                    protected void startService(Service service, CamelContext context, Object bean, String beanName) throws Exception {
                        if (this.isSingleton(bean, beanName)) {
                            this.getCamelContext().addService((Object)service);
                        } else {
                            ServiceHelper.startService((Object)service);
                            if (CamelBeanPostProcessor.this.prototypeBeans.add(beanName)) {
                                LOG.warn("The bean with id [{}] is prototype scoped and cannot stop the injected  service when bean is destroyed: {}. You may want to stop the service manually from the bean.", (Object)beanName, (Object)service);
                            }
                        }
                    }
                };
            }
            return this.camelPostProcessorHelper;
        }
    };

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessBeforeInitialization(bean, beanName);
        }
        catch (BeansException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("Error post processing bean: " + beanName, (Throwable)e);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessAfterInitialization(bean, beanName);
        }
        catch (BeansException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("Error post processing bean: " + beanName, (Throwable)e);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getCamelId() {
        return this.camelId;
    }

    public void setCamelId(String camelId) {
        this.camelId = camelId;
    }

    public boolean isBindToRegistrySupported() {
        return this.bindToRegistrySupported;
    }

    public void setBindToRegistrySupported(boolean bindToRegistrySupported) {
        this.bindToRegistrySupported = bindToRegistrySupported;
    }

    public void setEnabled(boolean enabled) {
        this.delegate.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }
}

