/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.SpringWebserviceHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.client.ActionCallback;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;
import org.springframework.ws.transport.http.HttpUrlConnection;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

public class SpringWebserviceProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebserviceProducer.class);

    public SpringWebserviceProducer(Endpoint endpoint) {
        super(endpoint);
        this.prepareMessageSenders(this.getEndpoint().getConfiguration());
    }

    public SpringWebserviceEndpoint getEndpoint() {
        return (SpringWebserviceEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) throws Exception {
        final Source sourcePayload = (Source)exchange.getIn().getMandatoryBody(Source.class);
        String endpointUriHeader = (String)exchange.getIn().getHeader("CamelSpringWebserviceEndpointUri", String.class);
        String soapActionHeader = (String)exchange.getIn().getHeader("CamelSpringWebserviceSoapAction", String.class);
        URI wsAddressingActionHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingAction", URI.class);
        URI wsReplyToHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingReplyTo", URI.class);
        URI wsFaultToHeader = (URI)exchange.getIn().getHeader("CamelSpringWebserviceAddressingFaultTo", URI.class);
        Source soapHeaderSource = (Source)exchange.getIn().getHeader("CamelSpringWebserviceSoapHeader", Source.class);
        final DefaultWebserviceMessageCallback callback = new DefaultWebserviceMessageCallback(soapActionHeader, wsAddressingActionHeader, wsReplyToHeader, wsFaultToHeader, soapHeaderSource, this.getEndpoint().getConfiguration(), exchange);
        if (endpointUriHeader == null) {
            endpointUriHeader = this.getEndpoint().getConfiguration().getWebServiceTemplate().getDefaultUri();
        }
        this.getEndpoint().getConfiguration().getWebServiceTemplate().sendAndReceive(endpointUriHeader, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage requestMessage) throws IOException, TransformerException {
                SpringWebserviceHelper.toResult(sourcePayload, requestMessage.getPayloadResult());
                callback.doWithMessage(requestMessage);
            }
        }, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage responseMessage) throws IOException, TransformerException {
                SoapMessage soapMessage = (SoapMessage)responseMessage;
                if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                    exchange.getOut().copyFromWithNewBody(exchange.getIn(), (Object)soapMessage.getPayloadSource());
                    SpringWebserviceProducer.this.populateHeaderAndAttachmentsFromResponse((AttachmentMessage)exchange.getOut(AttachmentMessage.class), soapMessage);
                } else {
                    exchange.getIn().setBody((Object)soapMessage.getPayloadSource());
                    SpringWebserviceProducer.this.populateHeaderAndAttachmentsFromResponse((AttachmentMessage)exchange.getIn(AttachmentMessage.class), soapMessage);
                }
            }
        });
    }

    private void populateHeaderAndAttachmentsFromResponse(AttachmentMessage inOrOut, SoapMessage soapMessage) {
        if (soapMessage.getSoapHeader() != null && this.getEndpoint().getConfiguration().isAllowResponseHeaderOverride()) {
            this.populateMessageHeaderFromResponse((Message)inOrOut, soapMessage.getSoapHeader());
        }
        if (soapMessage.getAttachments() != null && this.getEndpoint().getConfiguration().isAllowResponseAttachmentOverride()) {
            this.populateMessageAttachmentsFromResponse(inOrOut, soapMessage.getAttachments());
        }
    }

    private void populateMessageHeaderFromResponse(Message message, SoapHeader soapHeader) {
        message.setHeader("CamelSpringWebserviceSoapHeader", (Object)soapHeader.getSource());
        Iterator attIter = soapHeader.getAllAttributes();
        while (attIter.hasNext()) {
            QName name = (QName)attIter.next();
            message.getHeaders().put(name.getLocalPart(), soapHeader.getAttributeValue(name));
        }
        Iterator elementIter = soapHeader.examineAllHeaderElements();
        while (elementIter.hasNext()) {
            SoapHeaderElement element = (SoapHeaderElement)elementIter.next();
            QName name = element.getName();
            message.getHeaders().put(name.getLocalPart(), element);
        }
    }

    private void populateMessageAttachmentsFromResponse(AttachmentMessage inOrOut, Iterator<Attachment> attachments) {
        while (attachments.hasNext()) {
            Attachment attachment = attachments.next();
            inOrOut.addAttachment(attachment.getContentId(), attachment.getDataHandler());
        }
    }

    private void prepareMessageSenders(SpringWebserviceConfiguration configuration) {
        if (configuration.getTimeout() <= -1 && configuration.getSslContextParameters() == null) {
            return;
        }
        WebServiceTemplate webServiceTemplate = configuration.getWebServiceTemplate();
        WebServiceMessageSender[] messageSenders = webServiceTemplate.getMessageSenders();
        for (int i = 0; i < messageSenders.length; ++i) {
            WebServiceMessageSender messageSender = messageSenders[i];
            if (messageSender instanceof HttpComponentsMessageSender) {
                if (configuration.getSslContextParameters() != null) {
                    LOG.warn("Not applying SSLContextParameters based configuration to HttpComponentsMessageSender.  If you are using this MessageSender, which you are not by default, you will need to configure SSL using the Commons HTTP 3.x Protocol registry.");
                }
                if (configuration.getTimeout() <= -1) continue;
                if (messageSender.getClass().equals(HttpComponentsMessageSender.class)) {
                    ((HttpComponentsMessageSender)messageSender).setReadTimeout(configuration.getTimeout());
                    continue;
                }
                LOG.warn("Not applying timeout configuration to HttpComponentsMessageSender based implementation.  You are using what appears to be a custom MessageSender, which you are not doing by default. You will need configure timeout on your own.");
                continue;
            }
            if (messageSender.getClass().equals(HttpUrlConnectionMessageSender.class)) {
                messageSenders[i] = new AbstractHttpWebServiceMessageSenderDecorator((AbstractHttpWebServiceMessageSender)((HttpUrlConnectionMessageSender)messageSender), configuration, this.getEndpoint().getCamelContext());
                continue;
            }
            LOG.warn("Ignoring the timeout and SSLContextParameters options for {}.  You will need to configure these options directly on your custom configured WebServiceMessageSender", (Object)messageSender);
        }
    }

    protected static class DefaultWebserviceMessageCallback
    implements WebServiceMessageCallback {
        private final String soapActionHeader;
        private final URI wsAddressingActionHeader;
        private final URI wsReplyToHeader;
        private final URI wsFaultToHeader;
        private final Source soapHeaderSource;
        private final SpringWebserviceConfiguration configuration;
        private final Exchange exchange;

        public DefaultWebserviceMessageCallback(String soapAction, URI wsAddressingAction, URI wsReplyTo, URI wsFaultTo, Source soapHeaderSource, SpringWebserviceConfiguration configuration, Exchange exchange) {
            this.soapActionHeader = soapAction;
            this.wsAddressingActionHeader = wsAddressingAction;
            this.wsReplyToHeader = wsReplyTo;
            this.wsFaultToHeader = wsFaultTo;
            this.soapHeaderSource = soapHeaderSource;
            this.configuration = configuration;
            this.exchange = exchange;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
            URI wsFaultTo;
            String soapAction;
            String string = soapAction = this.soapActionHeader != null ? this.soapActionHeader : this.configuration.getSoapAction();
            if (soapAction != null) {
                new SoapActionCallback(soapAction).doWithMessage(message);
            }
            URI wsAddressingAction = this.wsAddressingActionHeader != null ? this.wsAddressingActionHeader : this.configuration.getWsAddressingAction();
            URI wsReplyTo = this.wsReplyToHeader != null ? this.wsReplyToHeader : this.configuration.getReplyTo();
            URI uRI = wsFaultTo = this.wsFaultToHeader != null ? this.wsFaultToHeader : this.configuration.getFaultTo();
            if (this.soapHeaderSource != null) {
                SoapHeader header = ((SoapMessage)message).getSoapHeader();
                SpringWebserviceHelper.toResult(this.soapHeaderSource, header.getResult());
            }
            if (wsAddressingAction != null) {
                ActionCallback actionCallback = new ActionCallback(wsAddressingAction);
                if (this.configuration.getMessageIdStrategy() != null) {
                    actionCallback.setMessageIdStrategy(this.configuration.getMessageIdStrategy());
                }
                if (wsReplyTo != null) {
                    actionCallback.setReplyTo(new EndpointReference(wsReplyTo));
                }
                if (wsFaultTo != null) {
                    actionCallback.setFaultTo(new EndpointReference(wsFaultTo));
                }
                actionCallback.doWithMessage(message);
            }
            this.configuration.getMessageFilter().filterProducer(this.exchange, message);
        }
    }

    protected static final class AbstractHttpWebServiceMessageSenderDecorator
    extends AbstractHttpWebServiceMessageSender {
        private final AbstractHttpWebServiceMessageSender delegate;
        private final SpringWebserviceConfiguration configuration;
        private final CamelContext camelContext;
        private final Lock lock = new ReentrantLock();
        private SSLContext sslContext;

        public AbstractHttpWebServiceMessageSenderDecorator(AbstractHttpWebServiceMessageSender delegate, SpringWebserviceConfiguration configuration, CamelContext camelContext) {
            this.delegate = delegate;
            this.configuration = configuration;
            this.camelContext = camelContext;
        }

        public WebServiceConnection createConnection(URI uri) throws IOException {
            WebServiceConnection wsc = this.delegate.createConnection(uri);
            if (wsc instanceof HttpUrlConnection) {
                HttpURLConnection connection = ((HttpUrlConnection)wsc).getConnection();
                if (this.configuration.getTimeout() > -1) {
                    connection.setReadTimeout(this.configuration.getTimeout());
                }
                if (this.configuration.getSslContextParameters() != null && connection instanceof HttpsURLConnection) {
                    this.lock.lock();
                    try {
                        if (this.sslContext == null) {
                            this.sslContext = this.configuration.getSslContextParameters().createSSLContext(this.camelContext);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeCamelException("Error creating SSLContext based on SSLContextParameters.", (Throwable)e);
                    }
                    finally {
                        this.lock.unlock();
                    }
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
                }
            } else {
                throw new RuntimeCamelException("Unsupported delegate.  Delegate must return a org.springframework.ws.transport.http.HttpUrlConnection.  Found " + String.valueOf(wsc.getClass()));
            }
            return wsc;
        }

        public boolean isAcceptGzipEncoding() {
            return this.delegate.isAcceptGzipEncoding();
        }

        public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
            this.delegate.setAcceptGzipEncoding(acceptGzipEncoding);
        }

        public boolean supports(URI uri) {
            return this.delegate.supports(uri);
        }
    }
}

