/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.springrabbit.EndpointMessageListener;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;

public class SpringRabbitMQConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRabbitMQConsumer.class);
    private AbstractMessageListenerContainer listenerContainer;
    private volatile EndpointMessageListener messageListener;
    private volatile boolean initialized;

    public SpringRabbitMQConsumer(Endpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super(endpoint, processor);
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setMessageListener((MessageListener)this.getEndpointMessageListener());
    }

    public SpringRabbitMQEndpoint getEndpoint() {
        return (SpringRabbitMQEndpoint)super.getEndpoint();
    }

    public EndpointMessageListener getEndpointMessageListener() {
        if (this.messageListener == null) {
            this.createMessageListener(this.getEndpoint(), this.getProcessor());
        }
        return this.messageListener;
    }

    protected void createMessageListener(SpringRabbitMQEndpoint endpoint, Processor processor) {
        this.messageListener = new EndpointMessageListener(this, endpoint, processor);
        endpoint.configureMessageListener(this.messageListener);
    }

    public void startListenerContainer() {
        LOG.trace("Starting listener container {} on queues: {}", (Object)this.listenerContainer, (Object)this.getEndpoint().getQueues());
        this.listenerContainer.start();
        LOG.debug("Started listener container {} on queues: {}", (Object)this.listenerContainer, (Object)this.getEndpoint().getQueues());
    }

    protected void testConnectionOnStartup() throws FailedToCreateConsumerException {
        Connection conn = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Testing RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
            }
            conn = this.listenerContainer.getConnectionFactory().createConnection();
            LOG.debug("Successfully tested RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
        }
        catch (Exception e) {
            try {
                throw new FailedToCreateConsumerException((Endpoint)this.getEndpoint(), (Throwable)e);
            }
            catch (Throwable throwable) {
                RabbitUtils.closeConnection(conn);
                throw throwable;
            }
        }
        RabbitUtils.closeConnection((Connection)conn);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        this.prepareAndStartListenerContainer();
        this.initialized = true;
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            this.stopAndDestroyListenerContainer();
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    protected void doResume() throws Exception {
        if (!this.initialized) {
            this.doStart();
        } else if (this.listenerContainer != null) {
            this.startListenerContainer();
        } else {
            LOG.warn("The listenerContainer is not instantiated. Probably there was a timeout during the Suspend operation. Please restart your consumer route.");
        }
    }

    protected void createMessageListenerContainer() throws Exception {
        this.listenerContainer = this.getEndpoint().createMessageListenerContainer();
        this.listenerContainer.setMessageListener((MessageListener)this.getEndpointMessageListener());
    }

    protected void prepareAndStartListenerContainer() {
        this.listenerContainer.afterPropertiesSet();
        if (this.getEndpoint().isAutoDeclare()) {
            this.getEndpoint().declareElements(this.listenerContainer);
        }
        if (this.initialized || this.getEndpoint().isAutoStartup()) {
            if (this.getEndpoint().isTestConnectionOnStartup()) {
                this.testConnectionOnStartup();
            }
            this.startListenerContainer();
        }
    }

    protected void stopAndDestroyListenerContainer() {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.destroy();
        }
        this.listenerContainer = null;
        this.messageListener = null;
        this.initialized = false;
    }
}

