/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.springrabbit.MessagePropertiesConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.springframework.amqp.core.MessageProperties;

public class DefaultMessagePropertiesConverter
implements MessagePropertiesConverter {
    private final CamelContext camelContext;
    private final HeaderFilterStrategy headerFilterStrategy;

    public DefaultMessagePropertiesConverter(CamelContext camelContext, HeaderFilterStrategy headerFilterStrategy) {
        this.camelContext = camelContext;
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public MessageProperties toMessageProperties(Exchange exchange) {
        MessageProperties answer = new MessageProperties();
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (contentType != null) {
            answer.setContentType(contentType);
        }
        Set entries = exchange.getMessage().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            this.appendOutputHeader(answer, headerName, headerValue, exchange);
        }
        return answer;
    }

    @Override
    public Map<String, Object> fromMessageProperties(MessageProperties messageProperties, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        if (messageProperties != null) {
            Set entries = messageProperties.getHeaders().entrySet();
            for (Map.Entry entry : entries) {
                String headerName = (String)entry.getKey();
                Object headerValue = entry.getValue();
                this.appendInputHeader(answer, headerName, headerValue, exchange);
            }
            if (messageProperties.getContentType() != null) {
                answer.put("Content-Type", messageProperties.getContentType());
            }
        }
        return answer;
    }

    private void appendOutputHeader(MessageProperties answer, String headerName, Object headerValue, Exchange ex) {
        if (this.shouldOutputHeader(headerName, headerValue, ex)) {
            answer.setHeader(headerName, headerValue);
        }
    }

    private void appendInputHeader(Map<String, Object> answer, String headerName, Object headerValue, Exchange ex) {
        if (this.shouldOutputHeader(headerName, headerValue, ex)) {
            answer.put(headerName, headerValue);
        }
    }

    protected boolean shouldOutputHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }

    protected boolean shouldInputHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToExternalHeaders(headerName, headerValue, exchange);
    }
}

