/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.security;

import java.util.Map;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.security.CamelSSLConfigurationProperties;
import org.apache.camel.util.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelSSLConfigurationProperties.class})
@Conditional(value={Condition.class})
public class CamelSSLAutoConfiguration {
    @Bean
    public GlobalSSLContextParametersSupplier sslContextParametersSupplier(CamelSSLConfigurationProperties properties) {
        SSLContextParameters config = properties.getConfig() != null ? properties.getConfig() : new SSLContextParameters();
        return () -> config;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "camel.ssl.config");
            Map sslProperties = resolver.getSubProperties(".");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.ssl.config", (Object[])new Object[0]);
            if (sslProperties.size() > 0) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }
    }
}

