/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthIndicator;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HealthIndicator.class})
@Conditional(value={Condition.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelHealthConfiguration.class})
public class CamelHealthAutoConfiguration {
    @Autowired
    private CamelHealthConfiguration configuration;

    @Bean
    @ConditionalOnBean(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CamelHealthIndicator.class})
    public HealthIndicator camelHealthIndicator(CamelContext camelContext) {
        return new CamelHealthIndicator(camelContext);
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.health", "camel.health.indicator");
        }
    }
}

