/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.spring.batch.SpringBatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

@org.apache.camel.spi.annotations.Component(value="spring-batch")
public class SpringBatchComponent
extends DefaultComponent {
    @Metadata(autowired=true)
    private JobLauncher jobLauncher;
    @Metadata(autowired=true)
    private JobRegistry jobRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SpringBatchEndpoint endpoint = new SpringBatchEndpoint(uri, (Component)this, this.jobLauncher, remaining, this.jobRegistry);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.jobLauncher == null) {
            this.jobLauncher = (JobLauncher)this.getCamelContext().getRegistry().lookupByNameAndType("jobLauncher", JobLauncher.class);
        }
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

