/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.splunkhec.SplunkHECConfiguration;
import org.apache.camel.component.splunkhec.SplunkHECEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.URISupport;

@Component(value="splunk-hec")
public class SplunkHECComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining.split("/").length > 1) {
            throw new IllegalArgumentException("Invalid URI: " + URISupport.sanitizeUri((String)uri));
        }
        SplunkHECEndpoint answer = new SplunkHECEndpoint(uri, this, new SplunkHECConfiguration());
        this.setProperties((Endpoint)answer, parameters);
        answer.setSplunkURL(remaining);
        return answer;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

