/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.Map;
import java.util.Set;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.component.solr.converter.SolrRequestConverter;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SolrOperation {
    DELETE((Map)Map.of("DELETE_BY_ID", "", "DELETE_BY_QUERY", "CamelSolrDeleteByQuery")){

        @Override
        SolrRequest<?> getSolrRequest(SolrProducer.ActionContext ctx) throws InvalidPayloadException {
            return SolrOperation.getSolrRequestForUpdates(ctx);
        }
    }
    ,
    INSERT((Map)Map.of("INSERT_STREAMING", "", "ADD_BEAN", "", "ADD_BEANS", "", "COMMIT", "SolrParam.commit", "SOFT_COMMIT", "SolrParam.softCommit", "OPTIMIZE", "SolrParam.optimize", "ROLLBACK", "SolrParam.rollback")){

        @Override
        SolrRequest<?> getSolrRequest(SolrProducer.ActionContext ctx) throws InvalidPayloadException {
            return SolrOperation.getSolrRequestForUpdates(ctx);
        }
    }
    ,
    PING(Map.of()){

        @Override
        SolrRequest<?> getSolrRequest(SolrProducer.ActionContext ctx) throws InvalidPayloadException {
            return (SolrRequest)ctx.exchange().getMessage().getMandatoryBody(SolrPing.class);
        }
    }
    ,
    SEARCH((Map)Map.of("QUERY", "")){

        @Override
        SolrRequest<?> getSolrRequest(SolrProducer.ActionContext ctx) throws InvalidPayloadException {
            return (SolrRequest)ctx.exchange().getMessage().getMandatoryBody(QueryRequest.class);
        }
    };

    final Map<String, String> actionsToDeprecate;

    private SolrOperation(Map<String, String> actionsToDeprecate) {
        this.actionsToDeprecate = actionsToDeprecate;
    }

    abstract SolrRequest<?> getSolrRequest(SolrProducer.ActionContext var1) throws InvalidPayloadException;

    private static SolrRequest<?> getSolrRequestForUpdates(SolrProducer.ActionContext ctx) throws InvalidPayloadException {
        if (SolrRequestConverter.isUseContentStreamUpdateRequest(ctx)) {
            return (SolrRequest)ctx.exchange().getMessage().getMandatoryBody(ContentStreamUpdateRequest.class);
        }
        return (SolrRequest)ctx.exchange().getMessage().getMandatoryBody(UpdateRequest.class);
    }

    public static SolrOperation getSolrOperationFrom(String actionString) {
        try {
            return SolrOperation.valueOf(actionString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (SolrOperation op : SolrOperation.values()) {
                for (String futureDeprecatedAction : op.getActionsToDeprecate()) {
                    if (!futureDeprecatedAction.equalsIgnoreCase(actionString)) continue;
                    return op;
                }
            }
            return null;
        }
    }

    public Set<String> getActionsToDeprecate() {
        return this.actionsToDeprecate.keySet();
    }

    public String getActionParameter(String actionString) {
        String actionParameter = this.actionsToDeprecate.get(actionString);
        return ObjectHelper.isNotEmpty((String)actionParameter) ? actionParameter : null;
    }

    public String createFutureDeprecationMessage(String actionString, String actionParameter) {
        Object message = String.format("The operation obtained from the exchange header '%s=%s' is going to be deprecated in future versions of camel-solr. Please use the operation value '%1$s=%s' instead", "CamelSolrOperation", actionString, this.name());
        if (actionParameter == null) {
            message = (String)message + ".";
        } else {
            message = (String)message + "and add the header '" + actionParameter + "=true' to the exchange for the desired operation. ";
            if (!actionString.equals("DELETE_BY_QUERY")) {
                message = (String)message + "For info on the solr parameters for commit related update requests, have a look at the solr documentation on https://solr.apache.org/guide/solr/latest/configuration-guide/commits-transaction-logs.html#explicit-commits";
            }
        }
        return message;
    }
}

