/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.component.snmp.SnmpHelper;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapProducer.class);
    private final SnmpEndpoint endpoint;
    private Address targetAddress;
    private USM usm;
    private Target target;

    public SnmpTrapProducer(SnmpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getServerAddress());
        LOG.debug("targetAddress: {}", (Object)this.targetAddress);
        this.usm = SnmpHelper.createAndSetUSM(this.endpoint);
        this.target = SnmpHelper.createTarget(this.endpoint);
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            if (this.usm != null) {
                SecurityModels.getInstance().removeSecurityModel(new Integer32(this.usm.getID()));
            }
        }
        finally {
            this.targetAddress = null;
            this.usm = null;
            this.target = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Snmp snmp = null;
        DefaultTcpTransportMapping transport = null;
        try {
            LOG.debug("Starting SNMP Trap producer on {}", (Object)this.endpoint.getServerAddress());
            if ("tcp".equals(this.endpoint.getProtocol())) {
                transport = new DefaultTcpTransportMapping();
            } else if ("udp".equals(this.endpoint.getProtocol())) {
                transport = new DefaultUdpTransportMapping();
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
            }
            snmp = new Snmp((TransportMapping)transport);
            LOG.debug("SnmpTrap: getting pdu from body");
            PDU trap = (PDU)exchange.getIn().getBody(PDU.class);
            trap.setErrorIndex(0);
            trap.setErrorStatus(0);
            if (this.endpoint.getSnmpVersion() == 0) {
                trap.setType(-92);
            } else {
                trap.setType(-89);
                trap.setMaxRepetitions(0);
            }
            LOG.debug("SnmpTrap: sending");
            snmp.send(trap, this.target);
            LOG.debug("SnmpTrap: sent");
        }
        finally {
            try {
                transport.close();
            }
            catch (Exception exception) {}
            try {
                snmp.close();
            }
            catch (Exception exception) {}
        }
    }
}

