/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSmCommand;
import org.apache.camel.component.smpp.SmppSplitter;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SMPPSession;

public class SmppSubmitSmCommand
extends SmppSmCommand {
    public SmppSubmitSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        SubmitSm[] submitSms = this.createSubmitSm(exchange);
        ArrayList<String> messageIDs = new ArrayList<String>(submitSms.length);
        for (int i = 0; i < submitSms.length; ++i) {
            String messageID;
            SubmitSm submitSm = submitSms[i];
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending short message {} for exchange id '{}'...", (Object)i, (Object)exchange.getExchangeId());
            }
            try {
                messageID = this.session.submitShortMessage(submitSm.getServiceType(), TypeOfNumber.valueOf((byte)submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getSourceAddrNpi()), submitSm.getSourceAddr(), TypeOfNumber.valueOf((byte)submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getDestAddrNpi()), submitSm.getDestAddress(), new ESMClass(submitSm.getEsmClass()), submitSm.getProtocolId(), submitSm.getPriorityFlag(), submitSm.getScheduleDeliveryTime(), submitSm.getValidityPeriod(), new RegisteredDelivery(submitSm.getRegisteredDelivery()), submitSm.getReplaceIfPresent(), DataCoding.newInstance((byte)submitSm.getDataCoding()), (byte)0, submitSm.getShortMessage(), submitSm.getOptionalParametes());
            }
            catch (Exception e) {
                throw new SmppException(e);
            }
            messageIDs.add(messageID);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent short message for exchange id '{}' and received message ids '{}'", (Object)exchange.getExchangeId(), messageIDs);
        }
        Message message = this.getResponseMessage(exchange);
        message.setHeader("CamelSmppId", messageIDs);
        message.setHeader("CamelSmppSentMessageCount", (Object)messageIDs.size());
    }

    protected SubmitSm[] createSubmitSm(Exchange exchange) {
        byte[] shortMessage = this.getShortMessage(exchange.getIn());
        SubmitSm template = this.createSubmitSmTemplate(exchange);
        SmppSplitter splitter = this.createSplitter(exchange.getIn());
        byte[][] segments = splitter.split(shortMessage);
        if (segments.length > 1) {
            template.setEsmClass(new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.UDHI).value());
        }
        SubmitSm[] submitSms = new SubmitSm[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            SubmitSm submitSm = SmppUtils.copySubmitSm(template);
            submitSm.setShortMessage(segments[i]);
            submitSms[i] = submitSm;
        }
        return submitSms;
    }

    protected SubmitSm createSubmitSmTemplate(Exchange exchange) {
        Message in = exchange.getIn();
        SubmitSm submitSm = new SubmitSm();
        if (in.getHeaders().containsKey("CamelSmppDataCoding")) {
            submitSm.setDataCoding(((Byte)in.getHeader("CamelSmppDataCoding", Byte.class)).byteValue());
        } else if (in.getHeaders().containsKey("CamelSmppAlphabet")) {
            submitSm.setDataCoding(((Byte)in.getHeader("CamelSmppAlphabet", Byte.class)).byteValue());
        } else {
            submitSm.setDataCoding(this.config.getDataCoding());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddr")) {
            submitSm.setDestAddress((String)in.getHeader("CamelSmppDestAddr", String.class));
        } else {
            submitSm.setDestAddress(this.config.getDestAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrTon")) {
            submitSm.setDestAddrTon(((Byte)in.getHeader("CamelSmppDestAddrTon", Byte.class)).byteValue());
        } else {
            submitSm.setDestAddrTon(this.config.getDestAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrNpi")) {
            submitSm.setDestAddrNpi(((Byte)in.getHeader("CamelSmppDestAddrNpi", Byte.class)).byteValue());
        } else {
            submitSm.setDestAddrNpi(this.config.getDestAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            submitSm.setSourceAddr((String)in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            submitSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            submitSm.setSourceAddrTon(((Byte)in.getHeader("CamelSmppSourceAddrTon", Byte.class)).byteValue());
        } else {
            submitSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            submitSm.setSourceAddrNpi(((Byte)in.getHeader("CamelSmppSourceAddrNpi", Byte.class)).byteValue());
        } else {
            submitSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            submitSm.setServiceType((String)in.getHeader("CamelSmppServiceType", String.class));
        } else {
            submitSm.setServiceType(this.config.getServiceType());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            submitSm.setRegisteredDelivery(((Byte)in.getHeader("CamelSmppRegisteredDelivery", Byte.class)).byteValue());
        } else {
            submitSm.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        if (in.getHeaders().containsKey("CamelSmppProtocolId")) {
            submitSm.setProtocolId(((Byte)in.getHeader("CamelSmppProtocolId", Byte.class)).byteValue());
        } else {
            submitSm.setProtocolId(this.config.getProtocolId());
        }
        if (in.getHeaders().containsKey("CamelSmppPriorityFlag")) {
            submitSm.setPriorityFlag(((Byte)in.getHeader("CamelSmppPriorityFlag", Byte.class)).byteValue());
        } else {
            submitSm.setPriorityFlag(this.config.getPriorityFlag());
        }
        if (in.getHeaders().containsKey("CamelSmppScheduleDeliveryTime")) {
            submitSm.setScheduleDeliveryTime(SmppUtils.formatTime((Date)in.getHeader("CamelSmppScheduleDeliveryTime", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppValidityPeriod")) {
            Object validityPeriod = in.getHeader("CamelSmppValidityPeriod");
            if (validityPeriod instanceof String) {
                submitSm.setValidityPeriod((String)validityPeriod);
            } else if (validityPeriod instanceof Date) {
                submitSm.setValidityPeriod(SmppUtils.formatTime((Date)validityPeriod));
            }
        }
        if (in.getHeaders().containsKey("CamelSmppReplaceIfPresentFlag")) {
            submitSm.setReplaceIfPresent(((Byte)in.getHeader("CamelSmppReplaceIfPresentFlag", Byte.class)).byteValue());
        } else {
            submitSm.setReplaceIfPresent(this.config.getReplaceIfPresentFlag());
        }
        submitSm.setEsmClass(new ESMClass().value());
        Map optinalParamaters = (Map)in.getHeader("CamelSmppOptionalParameters", Map.class);
        if (optinalParamaters != null) {
            ArrayList<OptionalParameter.OctetString> optParams = new ArrayList<OptionalParameter.OctetString>();
            for (Map.Entry entry : optinalParamaters.entrySet()) {
                OptionalParameter.OctetString optParam = null;
                try {
                    OptionalParameter.Tag tag = OptionalParameter.Tag.valueOf((String)((String)entry.getKey()));
                    Class<? extends OptionalParameter> type = this.determineTypeClass(tag);
                    if (OptionalParameter.OctetString.class.equals(type)) {
                        optParam = new OptionalParameter.OctetString(tag.code(), (String)entry.getValue());
                    } else if (OptionalParameter.COctetString.class.equals(type)) {
                        optParam = new OptionalParameter.COctetString(tag.code(), (String)entry.getValue());
                    } else if (OptionalParameter.Byte.class.equals(type)) {
                        optParam = new OptionalParameter.Byte(tag.code(), Byte.valueOf((String)entry.getValue()).byteValue());
                    } else if (OptionalParameter.Int.class.equals(type)) {
                        optParam = new OptionalParameter.Int(tag.code(), Integer.valueOf((String)entry.getValue()).intValue());
                    } else if (OptionalParameter.Short.class.equals(type)) {
                        optParam = new OptionalParameter.Short(tag.code(), Short.valueOf((String)entry.getValue()).shortValue());
                    } else if (OptionalParameter.Null.class.equals(type)) {
                        optParam = new OptionalParameter.Null(tag);
                    }
                    optParams.add(optParam);
                }
                catch (Exception e) {
                    this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", entry.getKey(), entry.getValue());
                }
            }
            submitSm.setOptionalParametes(optParams.toArray(new OptionalParameter[optParams.size()]));
        } else {
            submitSm.setOptionalParametes(new OptionalParameter[0]);
        }
        return submitSm;
    }

    protected Class<? extends OptionalParameter> determineTypeClass(OptionalParameter.Tag tag) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = tag.getClass().getDeclaredField("type");
        f.setAccessible(true);
        return (Class)f.get(tag);
    }
}

