/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiverListenerImpl
implements MessageReceiverListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(MessageReceiverListenerImpl.class);
    private MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private SmppEndpoint endpoint;
    private Processor processor;
    private ExceptionHandler exceptionHandler;

    public MessageReceiverListenerImpl(SmppEndpoint endpoint, Processor processor, ExceptionHandler exceptionHandler) {
        this.endpoint = endpoint;
        this.processor = processor;
        this.exceptionHandler = exceptionHandler;
    }

    public void onAcceptAlertNotification(AlertNotification alertNotification) {
        LOG.debug("Received an alertNotification {}", (Object)alertNotification);
        try {
            Exchange exchange = this.endpoint.createOnAcceptAlertNotificationExchange(alertNotification);
            LOG.trace("Processing the new smpp exchange...");
            this.processor.process(exchange);
            LOG.trace("Processed the new smpp exchange");
        }
        catch (Exception e) {
            this.exceptionHandler.handleException((Throwable)e);
        }
    }

    public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        block2: {
            LOG.debug("Received a deliverSm {}", (Object)deliverSm);
            try {
                Exchange exchange = this.endpoint.createOnAcceptDeliverSmExchange(deliverSm);
                LOG.trace("processing the new smpp exchange...");
                this.processor.process(exchange);
                LOG.trace("processed the new smpp exchange");
            }
            catch (Exception e) {
                this.exceptionHandler.handleException((Throwable)e);
                if (!(e instanceof ProcessRequestException)) break block2;
                throw (ProcessRequestException)e;
            }
        }
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session session) throws ProcessRequestException {
        LOG.debug("Received a dataSm {}", (Object)dataSm);
        MessageId newMessageId = this.messageIDGenerator.newMessageId();
        try {
            Exchange exchange = this.endpoint.createOnAcceptDataSm(dataSm, newMessageId.getValue());
            LOG.trace("processing the new smpp exchange...");
            this.processor.process(exchange);
            LOG.trace("processed the new smpp exchange");
        }
        catch (Exception e) {
            this.exceptionHandler.handleException((Throwable)e);
            if (e instanceof ProcessRequestException) {
                throw (ProcessRequestException)e;
            }
            throw new ProcessRequestException(e.getMessage(), 255, (Throwable)e);
        }
        return new DataSmResult(newMessageId, dataSm.getOptionalParametes());
    }

    public void setMessageIDGenerator(MessageIDGenerator messageIDGenerator) {
        this.messageIDGenerator = messageIDGenerator;
    }
}

