/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URI;
import java.nio.charset.Charset;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.smpp.SmppSplittingPolicy;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SessionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SmppConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(SmppConfiguration.class);
    @UriPath(defaultValue="localhost")
    private String host = "localhost";
    @UriPath(defaultValue="2775")
    private Integer port = 2775;
    @UriParam(defaultValue="smppclient")
    private String systemId = "smppclient";
    @UriParam
    private String password = "password";
    @UriParam(defaultValue="cp")
    private String systemType = "cp";
    @UriParam
    private byte dataCoding = 0;
    @UriParam(enums="0,4,8")
    private byte alphabet = Alphabet.ALPHA_DEFAULT.value();
    @UriParam(defaultValue="ISO-8859-1")
    private String encoding = "ISO-8859-1";
    @UriParam(defaultValue="5000")
    private Integer enquireLinkTimer = 5000;
    @UriParam(defaultValue="10000")
    private Integer transactionTimer = 10000;
    @UriParam(enums="0,1,2")
    private byte registeredDelivery = SMSCDeliveryReceipt.SUCCESS_FAILURE.value();
    @UriParam(defaultValue="CMT", enums="CMT,CPT,VMN,VMA,WAP,USSD")
    private String serviceType = "CMT";
    @UriParam(defaultValue="1616")
    private String sourceAddr = "1616";
    @UriParam(defaultValue="1717")
    private String destAddr = "1717";
    @UriParam(enums="0,1,2,3,4,5,6")
    private byte sourceAddrTon = TypeOfNumber.UNKNOWN.value();
    @UriParam(enums="0,1,2,3,4,5,6")
    private byte destAddrTon = TypeOfNumber.UNKNOWN.value();
    @UriParam(enums="0,1,2,3,6,8,9,10,13,18")
    private byte sourceAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam(enums="0,1,2,3,6,8,9,10,13,18")
    private byte destAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam
    private String addressRange = "";
    @UriParam
    private byte protocolId = 0;
    @UriParam(enums="0,1,2,3")
    private byte priorityFlag = 1;
    @UriParam(enums="0,1")
    private byte replaceIfPresentFlag = ReplaceIfPresentFlag.DEFAULT.value();
    @UriParam(enums="0,1,2,3,4,5,6")
    private byte typeOfNumber = TypeOfNumber.UNKNOWN.value();
    @UriParam(enums="0,1,2,3,6,8,9,10,13,18")
    private byte numberingPlanIndicator = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam
    private boolean usingSSL;
    @UriParam(defaultValue="5000")
    private long initialReconnectDelay = 5000L;
    @UriParam(defaultValue="5000")
    private long reconnectDelay = 5000L;
    @UriParam
    private boolean lazySessionCreation;
    @UriParam
    private String httpProxyHost;
    @UriParam(defaultValue="3128")
    private Integer httpProxyPort = 3128;
    @UriParam
    private String httpProxyUsername;
    @UriParam
    private String httpProxyPassword;
    @UriParam
    private SessionStateListener sessionStateListener;
    @UriParam(defaultValue="ALLOW")
    private SmppSplittingPolicy splittingPolicy = SmppSplittingPolicy.ALLOW;

    public void configureFromURI(URI uri) {
        this.setSystemId(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getScheme().startsWith("smpps")) {
            this.setUsingSSL(true);
        }
    }

    public SmppConfiguration copy() {
        try {
            return (SmppConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte dataCoding) {
        this.dataCoding = dataCoding;
    }

    public byte getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(byte alphabet) {
        this.alphabet = alphabet;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            LOG.warn("Unsupported encoding \"{}\" is being set.", (Object)encoding);
        }
        this.encoding = encoding;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    public void setEnquireLinkTimer(Integer enquireLinkTimer) {
        this.enquireLinkTimer = enquireLinkTimer;
    }

    public Integer getTransactionTimer() {
        return this.transactionTimer;
    }

    public void setTransactionTimer(Integer transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public byte getSourceAddrTon() {
        return this.sourceAddrTon;
    }

    public void setSourceAddrTon(byte sourceAddrTon) {
        this.sourceAddrTon = sourceAddrTon;
    }

    public byte getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(byte destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public byte getSourceAddrNpi() {
        return this.sourceAddrNpi;
    }

    public void setSourceAddrNpi(byte sourceAddrNpi) {
        this.sourceAddrNpi = sourceAddrNpi;
    }

    public byte getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(byte destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(byte protocolId) {
        this.protocolId = protocolId;
    }

    public byte getPriorityFlag() {
        return this.priorityFlag;
    }

    public void setPriorityFlag(byte priorityFlag) {
        this.priorityFlag = priorityFlag;
    }

    public byte getReplaceIfPresentFlag() {
        return this.replaceIfPresentFlag;
    }

    public void setReplaceIfPresentFlag(byte replaceIfPresentFlag) {
        this.replaceIfPresentFlag = replaceIfPresentFlag;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public String getDestAddr() {
        return this.destAddr;
    }

    public void setDestAddr(String destAddr) {
        this.destAddr = destAddr;
    }

    public byte getTypeOfNumber() {
        return this.typeOfNumber;
    }

    public void setTypeOfNumber(byte typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
    }

    public byte getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(byte numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public boolean getUsingSSL() {
        return this.usingSSL;
    }

    public void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public SessionStateListener getSessionStateListener() {
        return this.sessionStateListener;
    }

    public void setSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public SmppSplittingPolicy getSplittingPolicy() {
        return this.splittingPolicy;
    }

    public void setSplittingPolicy(SmppSplittingPolicy splittingPolicy) {
        this.splittingPolicy = splittingPolicy;
    }

    public String toString() {
        return "SmppConfiguration[usingSSL=" + this.usingSSL + ", enquireLinkTimer=" + this.enquireLinkTimer + ", host=" + this.host + ", password=" + this.password + ", port=" + this.port + ", systemId=" + this.systemId + ", systemType=" + this.systemType + ", dataCoding=" + this.dataCoding + ", alphabet=" + this.alphabet + ", encoding=" + this.encoding + ", transactionTimer=" + this.transactionTimer + ", registeredDelivery=" + this.registeredDelivery + ", serviceType=" + this.serviceType + ", sourceAddrTon=" + this.sourceAddrTon + ", destAddrTon=" + this.destAddrTon + ", sourceAddrNpi=" + this.sourceAddrNpi + ", destAddrNpi=" + this.destAddrNpi + ", addressRange=" + this.addressRange + ", protocolId=" + this.protocolId + ", priorityFlag=" + this.priorityFlag + ", replaceIfPresentFlag=" + this.replaceIfPresentFlag + ", sourceAddr=" + this.sourceAddr + ", destAddr=" + this.destAddr + ", typeOfNumber=" + this.typeOfNumber + ", numberingPlanIndicator=" + this.numberingPlanIndicator + ", initialReconnectDelay=" + this.initialReconnectDelay + ", reconnectDelay=" + this.reconnectDelay + ", lazySessionCreation=" + this.lazySessionCreation + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + ", splittingPolicy=" + (Object)((Object)this.splittingPolicy) + "]";
    }
}

