/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.TypeConverterRegistry;
import org.smooks.io.sink.DOMSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StringSink;
import org.smooks.io.source.StringSource;
import org.w3c.dom.Node;

@Converter(generateLoader=true)
public class SinkConverter {
    public static final String SMOOKS_RESULT_KEY = "SmooksResultKeys";

    private SinkConverter() {
    }

    @Converter
    public static Node toDocument(DOMSink domSink) {
        return domSink.getNode();
    }

    @Converter
    public static List toList(JavaSink.ResultMap javaResult, Exchange exchange) {
        String resultKey = (String)exchange.getProperty(SMOOKS_RESULT_KEY);
        if (resultKey != null) {
            return (List)SinkConverter.getResultsFromJavaSink(javaResult, resultKey);
        }
        return (List)SinkConverter.getSingleObjectFromJavaSink(javaResult);
    }

    @Converter
    public static Integer toInteger(JavaSink.ResultMap result) {
        return (Integer)SinkConverter.getSingleObjectFromJavaSink(result);
    }

    @Converter
    public static Double toDouble(JavaSink.ResultMap result) {
        return (Double)SinkConverter.getSingleObjectFromJavaSink(result);
    }

    @Converter
    public static String toString(StringSink result) {
        return result.getResult();
    }

    public static Map toMap(JavaSink.ResultMap resultBeans, Exchange exchange) {
        Message outMessage = exchange.getOut();
        outMessage.setBody((Object)resultBeans);
        Set entrySet = resultBeans.entrySet();
        for (Map.Entry entry : entrySet) {
            outMessage.setBody(entry.getValue(), entry.getValue().getClass());
        }
        return resultBeans;
    }

    private static Object getResultsFromJavaSink(JavaSink.ResultMap resultMap, String resultKey) {
        return resultMap.get((Object)resultKey);
    }

    private static Object getSingleObjectFromJavaSink(JavaSink.ResultMap resultMap) {
        if (resultMap.size() == 1) {
            return resultMap.values().iterator().next();
        }
        return null;
    }

    @Converter
    public static StringSource toStringSource(StringSink stringResult) {
        String result = stringResult.getResult();
        return new StringSource(result);
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (value instanceof JavaSink.ResultMap) {
            for (Object mapValue : ((Map)value).values()) {
                if (!type.isInstance(mapValue)) continue;
                return type.cast(mapValue);
            }
        }
        return null;
    }
}

