/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.routing;

import org.apache.camel.component.smooks.routing.BeanRouter;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.expression.ExecutionContextExpressionEvaluator;
import org.smooks.assertion.AssertArgument;

public class BeanRouterObserver
implements BeanContextLifecycleObserver {
    private final BeanRouter beanRouter;
    private final String beanId;
    private ExecutionContextExpressionEvaluator conditionEvaluator;

    public BeanRouterObserver(BeanRouter beanRouter, String beanId) {
        AssertArgument.isNotNull((Object)beanRouter, (String)"beanRouter");
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        this.beanRouter = beanRouter;
        this.beanId = beanId;
    }

    public void setConditionEvaluator(ExecutionContextExpressionEvaluator conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }

    public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
        if (this.endEventAndBeanIdMatch(event) && this.conditionsMatch(event)) {
            this.beanRouter.sendBean(event.getBean(), event.getExecutionContext());
        }
    }

    private boolean endEventAndBeanIdMatch(BeanContextLifecycleEvent event) {
        return event.getLifecycle() == BeanLifecycle.END_FRAGMENT && event.getBeanId().getName().equals(this.beanId);
    }

    public boolean conditionsMatch(BeanContextLifecycleEvent event) {
        if (this.conditionEvaluator == null) {
            return true;
        }
        try {
            return this.conditionEvaluator.eval(event.getExecutionContext());
        }
        catch (Exception e) {
            return false;
        }
    }
}

