/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.smooks.converter.SinkConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.smooks.io.sink.DOMSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StringSink;
import org.smooks.io.source.StringSource;
import org.w3c.dom.Node;

@DeferredContextBinding
public final class SinkConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SinkConverterLoader.addTypeConverter(registry, Double.class, JavaSink.ResultMap.class, false, (type, exchange, value) -> SinkConverter.toDouble((JavaSink.ResultMap)value));
        SinkConverterLoader.addTypeConverter(registry, Integer.class, JavaSink.ResultMap.class, false, (type, exchange, value) -> SinkConverter.toInteger((JavaSink.ResultMap)value));
        SinkConverterLoader.addTypeConverter(registry, String.class, StringSink.class, false, (type, exchange, value) -> SinkConverter.toString((StringSink)value));
        SinkConverterLoader.addTypeConverter(registry, List.class, JavaSink.ResultMap.class, false, (type, exchange, value) -> SinkConverter.toList((JavaSink.ResultMap)value, exchange));
        SinkConverterLoader.addTypeConverter(registry, StringSource.class, StringSink.class, false, (type, exchange, value) -> SinkConverter.toStringSource((StringSink)value));
        SinkConverterLoader.addTypeConverter(registry, Node.class, DOMSink.class, false, (type, exchange, value) -> SinkConverter.toDocument((DOMSink)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        SinkConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> SinkConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

