/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.component.smb.SmbOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbProducer
extends GenericFileProducer<FileIdBothDirectoryInformation> {
    private static final Logger LOG = LoggerFactory.getLogger(SmbProducer.class);

    protected SmbProducer(SmbEndpoint endpoint, GenericFileOperations<FileIdBothDirectoryInformation> operations) {
        super((GenericFileEndpoint)endpoint, operations);
    }

    public SmbEndpoint getEndpoint() {
        return (SmbEndpoint)super.getEndpoint();
    }

    public void postWriteCheck(Exchange exchange) {
        try {
            boolean isLast = (Boolean)exchange.getProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)false, Boolean.class);
            if (isLast && this.getEndpoint().getConfiguration().isDisconnectOnBatchComplete()) {
                LOG.trace("postWriteCheck disconnect on batch complete from: {}", (Object)this.getEndpoint());
                this.getOperations().disconnect();
            }
            if (this.getEndpoint().getConfiguration().isDisconnect()) {
                LOG.trace("postWriteCheck disconnect from: {}", (Object)this.getEndpoint());
                this.getOperations().disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            LOG.warn("Exception occurred during disconnecting from: {} {}. This exception is ignored.", (Object)this.getEndpoint(), (Object)e.getMessage());
        }
    }

    private SmbOperations getOperations() {
        return (SmbOperations)this.operations;
    }
}

