/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="slack:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Slack consumer response details")
public class SlackCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.slack.consume");
        if (ObjectHelper.isNotEmpty((String)((com.slack.api.model.Message)message.getBody(com.slack.api.model.Message.class)).getAppId())) {
            headers.put("CamelCloudEventSource", "slack." + ObjectHelper.isNotEmpty((String)((com.slack.api.model.Message)message.getBody(com.slack.api.model.Message.class)).getAppId()));
        }
        if (ObjectHelper.isNotEmpty((String)((com.slack.api.model.Message)message.getBody(com.slack.api.model.Message.class)).getChannel())) {
            headers.put("CamelCloudEventSubject", ObjectHelper.isNotEmpty((String)((com.slack.api.model.Message)message.getBody(com.slack.api.model.Message.class)).getChannel()));
        }
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

