/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.model.Message;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.slack.SlackEndpoint;
import org.apache.camel.component.slack.helper.SlackHelper;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.support.DefaultAsyncProducer;

public class SlackProducer
extends DefaultAsyncProducer {
    private static final Gson GSON = new Gson();
    private final SlackEndpoint slackEndpoint;
    private Slack slack;

    public SlackProducer(SlackEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.slackEndpoint = endpoint;
    }

    protected void doStart() throws Exception {
        SlackConfig config = SlackHelper.createSlackConfig(this.slackEndpoint.getServerUrl());
        SlackHttpClient client = new SlackHttpClient();
        this.slack = Slack.getInstance((SlackConfig)config, (SlackHttpClient)client);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.slack != null) {
            this.slack.close();
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.slackEndpoint.getToken() != null) {
            return this.sendMessageByToken(exchange, callback);
        }
        return this.sendMessageByWebhookURL(exchange, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessageByToken(Exchange exchange, AsyncCallback callback) {
        ChatPostMessageResponse response;
        Object payload = exchange.getIn().getBody();
        try {
            if (payload instanceof SlackMessage) {
                response = this.sendLegacySlackMessage((SlackMessage)payload);
            } else if (payload instanceof Message) {
                response = this.sendMessage((Message)payload);
            } else {
                SlackMessage slackMessage = new SlackMessage();
                slackMessage.setText((String)exchange.getIn().getBody(String.class));
                response = this.sendLegacySlackMessage(slackMessage);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            callback.done(true);
        }
        if (!response.isOk()) {
            exchange.setException((Throwable)new CamelExchangeException("Error POSTing to Slack API: " + response.toString(), exchange));
        }
        return false;
    }

    private ChatPostMessageResponse sendLegacySlackMessage(SlackMessage slackMessage) throws IOException, SlackApiException {
        return this.slack.methods(this.slackEndpoint.getToken()).chatPostMessage(req -> req.channel(this.slackEndpoint.getChannel()).username(this.slackEndpoint.getUsername()).iconUrl(this.slackEndpoint.getIconUrl()).iconEmoji(this.slackEndpoint.getIconEmoji()).text(slackMessage.getText()));
    }

    private ChatPostMessageResponse sendMessage(Message message) throws IOException, SlackApiException {
        return this.slack.methods(this.slackEndpoint.getToken()).chatPostMessage(req -> req.channel(this.slackEndpoint.getChannel()).username(this.slackEndpoint.getUsername()).iconUrl(this.slackEndpoint.getIconUrl()).iconEmoji(this.slackEndpoint.getIconEmoji()).text(message.getText()).blocks(message.getBlocks()).attachments(message.getAttachments()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessageByWebhookURL(Exchange exchange, AsyncCallback callback) {
        WebhookResponse response;
        String json;
        Object payload = exchange.getIn().getBody();
        if (payload instanceof SlackMessage) {
            json = GSON.toJson((Object)this.addEndPointOptions((SlackMessage)payload));
        } else if (payload instanceof Message) {
            json = GSON.toJson((Object)this.addEndPointOptions((Message)payload));
        } else {
            SlackMessage slackMessage = new SlackMessage();
            slackMessage.setText((String)exchange.getIn().getBody(String.class));
            json = GSON.toJson((Object)this.addEndPointOptions(slackMessage));
        }
        try {
            response = this.slack.send(this.slackEndpoint.getWebhookUrl(), json);
        }
        catch (IOException e) {
            exchange.setException((Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            callback.done(true);
        }
        if (response.getCode() < 200 || response.getCode() > 299) {
            exchange.setException((Throwable)new CamelExchangeException("Error POSTing to Slack API: " + response.toString(), exchange));
        }
        return false;
    }

    private Message addEndPointOptions(Message slackMessage) {
        slackMessage.setChannel(this.slackEndpoint.getChannel());
        slackMessage.setUsername(this.slackEndpoint.getUsername());
        return slackMessage;
    }

    private SlackMessage addEndPointOptions(SlackMessage slackMessage) {
        slackMessage.setChannel(this.slackEndpoint.getChannel());
        slackMessage.setUsername(this.slackEndpoint.getUsername());
        slackMessage.setIconUrl(this.slackEndpoint.getIconUrl());
        slackMessage.setIconEmoji(this.slackEndpoint.getIconEmoji());
        return slackMessage;
    }
}

