/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.SessionMessageListener;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.task.BackgroundTask;
import org.apache.camel.support.task.TaskRunFailureException;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.TimeBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessageListenerContainer
extends ServiceSupport
implements MessageListenerContainer,
ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessageListenerContainer.class);
    private final SjmsEndpoint endpoint;
    private SessionMessageListener messageListener;
    private String clientId;
    private int concurrentConsumers = 1;
    private ExceptionListener exceptionListener;
    private String destinationName;
    private DestinationCreationStrategy destinationCreationStrategy;
    private final Lock connectionLock = new ReentrantLock();
    private Connection connection;
    private volatile boolean connectionStarted;
    private final Lock consumerLock = new ReentrantLock();
    private Set<MessageConsumer> consumers;
    private Set<Session> sessions;
    private ScheduledExecutorService recoverPool;
    private BackgroundTask recoverTask;
    private Future<?> recoverFuture;

    public SimpleMessageListenerContainer(SjmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public SjmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setMessageListener(SessionMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.endpoint.getConnectionFactory();
    }

    protected void configureConsumer(MessageConsumer consumer, Session session) throws Exception {
        consumer.setMessageListener((MessageListener)new SimpleMessageListener(this.messageListener, session));
    }

    public void onException(JMSException exception) {
        if (this.exceptionListener != null) {
            try {
                this.exceptionListener.onException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (this.endpoint.getExceptionListener() != null) {
            try {
                this.endpoint.getExceptionListener().onException(exception);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        this.connectionLock.lock();
        try {
            this.sessions = null;
            this.consumers = null;
        }
        finally {
            this.connectionLock.unlock();
        }
        this.scheduleConnectionRecovery();
    }

    protected boolean recoverConnection(BackgroundTask task) {
        LOG.debug("Recovering from JMS Connection exception (attempt: {})", (Object)task.iteration());
        try {
            this.refreshConnection();
            this.initConsumers();
            LOG.debug("Successfully recovered JMS Connection (attempt: {})", (Object)task.iteration());
            return false;
        }
        catch (Exception e) {
            String message = "Failed to recover JMS Connection (attempt: " + task.iteration() + "). Will try again in " + this.endpoint.getRecoveryInterval() + " millis";
            LOG.warn(message);
            throw new TaskRunFailureException(message, (Throwable)e);
        }
    }

    protected void scheduleConnectionRecovery() {
        this.connectionLock.lock();
        try {
            if (this.recoverPool == null) {
                this.recoverPool = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SjmsConnectionRecovery");
            }
            if (this.recoverTask == null) {
                this.recoverTask = this.createTask();
                this.recoverFuture = this.recoverTask.schedule(this.endpoint.getCamelContext(), () -> this.recoverConnection(this.recoverTask));
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private BackgroundTask createTask() {
        return (BackgroundTask)Tasks.backgroundTask().withScheduledExecutor(this.recoverPool).withBudget((TimeBudget)Budgets.iterationTimeBudget().withInterval(Duration.ofMillis(this.endpoint.getRecoveryInterval())).withInitialDelay(Duration.ofSeconds(1L)).withUnlimitedDuration().build()).withName("SjmsConnectionRecovery").build();
    }

    protected void doStart() throws Exception {
        this.createConnection();
        this.initConsumers();
        this.startConnection();
    }

    protected void doStop() throws Exception {
        this.stopConnection();
        this.stopConsumers();
        if (this.recoverPool != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.recoverPool);
            this.recoverPool = null;
        }
        if (this.recoverFuture != null && this.recoverTask != null && this.recoverTask.isRunning()) {
            this.recoverFuture.cancel(true);
            this.recoverTask = null;
            this.recoverFuture = null;
        }
    }

    protected void doShutdown() throws Exception {
        SjmsHelper.closeConnection(this.connection);
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConsumers() throws Exception {
        this.consumerLock.lock();
        try {
            if (this.consumers == null) {
                LOG.debug("Initializing {} concurrent consumers as JMS listener on destination: {}", (Object)this.concurrentConsumers, (Object)this.destinationName);
                this.sessions = new HashSet<Session>(this.concurrentConsumers);
                this.consumers = new HashSet<MessageConsumer>(this.concurrentConsumers);
                for (int i = 0; i < this.concurrentConsumers; ++i) {
                    Session session = this.createSession(this.connection, this.endpoint);
                    MessageConsumer consumer = this.createMessageConsumer(session);
                    this.configureConsumer(consumer, session);
                    this.sessions.add(session);
                    this.consumers.add(consumer);
                }
            }
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    protected Session createSession(Connection connection, SjmsEndpoint endpoint) throws Exception {
        return connection.createSession(endpoint.isTransacted(), endpoint.getAcknowledgementMode().intValue());
    }

    protected MessageConsumer createMessageConsumer(Session session) throws Exception {
        return this.endpoint.getJmsObjectFactory().createMessageConsumer(session, (Endpoint)this.endpoint);
    }

    protected void stopConsumers() {
        this.consumerLock.lock();
        try {
            if (this.consumers != null) {
                LOG.debug("Stopping JMS MessageConsumers");
                for (MessageConsumer consumer : this.consumers) {
                    SjmsHelper.closeConsumer(consumer);
                }
                if (this.sessions != null) {
                    LOG.debug("Stopping JMS Sessions");
                    for (Session session : this.sessions) {
                        SjmsHelper.closeSession(session);
                    }
                }
            }
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    protected void createConnection() throws Exception {
        block6: {
            this.connectionLock.lock();
            try {
                if (this.connection != null) break block6;
                Connection con = null;
                try {
                    String cid;
                    con = this.endpoint.getConnectionFactory().createConnection();
                    String string = cid = this.clientId != null ? this.clientId : this.endpoint.getClientId();
                    if (cid != null) {
                        con.setClientID(cid);
                    }
                    con.setExceptionListener((ExceptionListener)this);
                }
                catch (JMSException e) {
                    SjmsHelper.closeConnection(con);
                    throw e;
                }
                this.connection = con;
                LOG.debug("Created JMS Connection");
            }
            finally {
                this.connectionLock.unlock();
            }
        }
    }

    protected final void refreshConnection() throws Exception {
        this.connectionLock.lock();
        try {
            SjmsHelper.closeConnection(this.connection);
            this.connection = null;
            this.createConnection();
            if (this.connectionStarted) {
                this.startConnection();
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    protected void startConnection() throws Exception {
        this.connectionLock.lock();
        try {
            this.connectionStarted = true;
            if (this.connection != null) {
                try {
                    this.connection.start();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    protected void stopConnection() {
        this.connectionLock.lock();
        try {
            this.connectionStarted = false;
            if (this.connection != null) {
                try {
                    this.connection.stop();
                }
                catch (Exception e) {
                    LOG.debug("Error stopping connection. This exception is ignored.", (Throwable)e);
                }
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private class SimpleMessageListener
    implements MessageListener {
        private final SessionMessageListener messageListener;
        private final Session session;

        public SimpleMessageListener(SessionMessageListener messageListener, Session session) {
            this.messageListener = messageListener;
            this.session = session;
        }

        public void onMessage(Message message) {
            try {
                this.doOnMessage(message);
            }
            catch (Exception e) {
                if (e instanceof JMSException) {
                    if (SimpleMessageListenerContainer.this.endpoint.getExceptionListener() != null) {
                        SimpleMessageListenerContainer.this.endpoint.getExceptionListener().onException((JMSException)((Object)e));
                    }
                }
                LOG.warn("Execution of JMS message listener failed. This exception is ignored.", (Throwable)e);
            }
        }

        protected void doOnMessage(Message message) throws Exception {
            try {
                this.messageListener.onMessage(message, this.session);
            }
            catch (Exception e) {
                SjmsHelper.rollbackIfNeeded(this.session);
                throw e;
            }
            SjmsHelper.commitIfNeeded(this.session, message);
        }
    }
}

