/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.support.SynchronizationAdapter;

class TransactionOnCompletion
extends SynchronizationAdapter {
    private final Session session;
    private final Message message;

    public TransactionOnCompletion(Session session, Message message) {
        this.session = session;
        this.message = message;
    }

    public void onDone(Exchange exchange) {
        try {
            if (exchange.isFailed() || exchange.isRollbackOnly()) {
                SjmsHelper.rollbackIfNeeded(this.session);
            } else {
                SjmsHelper.commitIfNeeded(this.session, this.message);
            }
        }
        catch (Exception exception) {
        }
        finally {
            SjmsHelper.closeSession(this.session);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionOnCompletion)) {
            return false;
        }
        TransactionOnCompletion that = (TransactionOnCompletion)((Object)o);
        return this.session == that.session && this.message == that.message;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.session, this.message);
    }
}

