/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.reply;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.reply.CorrelationTimeoutMap;
import org.apache.camel.component.sjms.reply.QueueReplyHandler;
import org.apache.camel.component.sjms.reply.ReplyHandler;
import org.apache.camel.component.sjms.reply.ReplyHolder;
import org.apache.camel.component.sjms.reply.ReplyManager;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplyManagerSupport
extends ServiceSupport
implements ReplyManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CamelContext camelContext;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ExecutorService executorService;
    protected SjmsEndpoint endpoint;
    protected Destination replyTo;
    protected MessageListenerContainer listenerContainer;
    protected final CountDownLatch replyToLatch = new CountDownLatch(1);
    protected final long replyToTimeout = 10000L;
    protected CorrelationTimeoutMap correlation;

    public ReplyManagerSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.scheduledExecutorService = executorService;
    }

    @Override
    public void setOnTimeoutExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void setEndpoint(SjmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setReplyTo(Destination replyTo) {
        this.log.trace("ReplyTo destination: {}", (Object)replyTo);
        this.replyTo = replyTo;
        this.replyToLatch.countDown();
    }

    @Override
    public Destination getReplyTo() {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        try {
            this.log.trace("Waiting for replyTo to be set");
            boolean done = this.replyToLatch.await(10000L, TimeUnit.MILLISECONDS);
            if (!done) {
                this.log.warn("ReplyTo destination was not set and timeout occurred");
            } else {
                this.log.trace("Waiting for replyTo to be set done");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.replyTo;
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        QueueReplyHandler handler = new QueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        ReplyHandler result = this.correlation.putIfAbsent(correlationId, handler, requestTimeout);
        if (result != null) {
            String logMessage = String.format("The correlationId [%s] is not unique.", correlationId);
            throw new IllegalArgumentException(logMessage);
        }
        return correlationId;
    }

    @Override
    public void onMessage(jakarta.jms.Message message, Session session) throws JMSException {
        String correlationID = JmsMessageHelper.getJMSCorrelationID(message);
        if (correlationID == null) {
            this.log.warn("Ignoring message with no correlationID: {}", (Object)message);
            return;
        }
        this.log.debug("Received reply message with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        this.handleReplyMessage(correlationID, message, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processReply(ReplyHolder holder) {
        if (holder != null && this.isRunAllowed()) {
            try {
                Exchange exchange = holder.getExchange();
                boolean timeout = holder.isTimeout();
                if (timeout) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Timeout occurred after {} millis waiting for reply message with correlationID [{}] on destination {}. Setting ExchangeTimedOutException on {} and continue routing.", new Object[]{holder.getRequestTimeout(), holder.getCorrelationId(), this.replyTo, ExchangeHelper.logIds((Exchange)exchange)});
                    }
                    String msg = "reply message with correlationID: " + holder.getCorrelationId() + " not received on destination: " + String.valueOf(this.replyTo);
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, holder.getRequestTimeout(), msg));
                } else {
                    jakarta.jms.Message message = holder.getMessage();
                    Session session = holder.getSession();
                    SjmsMessage response = new SjmsMessage(exchange, message, session, this.endpoint.getBinding());
                    exchange.setOut((Message)response);
                    Object body = response.getBody();
                    if (this.endpoint.isTransferException() && body instanceof Exception) {
                        this.log.debug("Reply was an Exception. Setting the Exception on the Exchange: {}", body);
                        exchange.setException((Throwable)((Exception)body));
                    } else {
                        this.log.debug("Reply received. OUT message body set to reply payload: {}", body);
                    }
                    if (holder.getOriginalCorrelationId() != null) {
                        JmsMessageHelper.setCorrelationId(message, holder.getOriginalCorrelationId());
                        exchange.getOut().setHeader("JMSCorrelationID", (Object)holder.getOriginalCorrelationId());
                    }
                }
            }
            finally {
                AsyncCallback callback = holder.getCallback();
                callback.done(false);
            }
        }
    }

    protected abstract void handleReplyMessage(String var1, jakarta.jms.Message var2, Session var3);

    protected abstract MessageListenerContainer createListenerContainer() throws Exception;

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.executorService, (String)"executorService", (Object)this);
        ObjectHelper.notNull((Object)this.scheduledExecutorService, (String)"scheduledExecutorService", (Object)this);
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint", (Object)this);
        this.log.trace("Using timeout checker interval with {} millis", (Object)this.endpoint.getComponent().getRequestTimeoutCheckerInterval());
        this.correlation = new CorrelationTimeoutMap(this.scheduledExecutorService, this.endpoint.getComponent().getRequestTimeoutCheckerInterval(), this.executorService);
        ServiceHelper.startService((Service)this.correlation);
        this.listenerContainer = this.createListenerContainer();
        this.listenerContainer.afterPropertiesConfigured(this.endpoint.getCamelContext());
        this.log.debug("Starting reply listener container on endpoint: {}", (Object)this.endpoint);
        ServiceHelper.startService((Service)this.listenerContainer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.correlation);
        if (this.listenerContainer != null) {
            this.log.debug("Stopping reply listener container on endpoint: {}", (Object)this.endpoint);
            try {
                ServiceHelper.stopAndShutdownService((Object)this.listenerContainer);
            }
            finally {
                this.listenerContainer = null;
            }
        }
        if (this.scheduledExecutorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
    }
}

