/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sjms.ReplyToType;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.SjmsTemplate;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.MessageCreator;
import org.apache.camel.component.sjms.reply.QueueReplyManager;
import org.apache.camel.component.sjms.reply.ReplyManager;
import org.apache.camel.component.sjms.reply.TemporaryQueueReplyManager;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SjmsProducer.class);
    private static final String GENERATED_CORRELATION_ID_PREFIX = "Camel-";
    private final SjmsEndpoint endpoint;
    private final AtomicBoolean started = new AtomicBoolean();
    private SjmsTemplate inOnlyTemplate;
    private SjmsTemplate inOutTemplate;
    private UuidGenerator uuidGenerator;
    private ReplyManager replyManager;

    public SjmsProducer(SjmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.uuidGenerator == null) {
            this.uuidGenerator = this.getEndpoint().getCamelContext().getUuidGenerator();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.isTestConnectionOnStartup()) {
            this.testConnectionOnStartup();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.unInitReplyManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initReplyManager() {
        if (!this.started.get()) {
            SjmsProducer sjmsProducer = this;
            synchronized (sjmsProducer) {
                if (this.started.get()) {
                    return;
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader ac = this.endpoint.getCamelContext().getApplicationContextClassLoader();
                try {
                    if (ac != null) {
                        Thread.currentThread().setContextClassLoader(ac);
                    }
                    if (this.endpoint.getReplyToType() != null && this.endpoint.getReplyTo() != null && this.endpoint.getReplyToType().equals((Object)ReplyToType.Temporary)) {
                        throw new IllegalArgumentException("ReplyToType " + ReplyToType.Temporary + " is not supported when replyTo " + this.endpoint.getReplyTo() + " is also configured.");
                    }
                    if (this.endpoint.getReplyTo() != null) {
                        this.replyManager = this.createReplyManager(this.endpoint.getReplyTo());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Using JmsReplyManager: {} to process replies from: {}", (Object)this.replyManager, (Object)this.endpoint.getReplyTo());
                        }
                    } else {
                        this.replyManager = this.createReplyManager();
                        LOG.debug("Using JmsReplyManager: {} to process replies from temporary queue", (Object)this.replyManager);
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.endpoint, (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                this.started.set(true);
            }
        }
    }

    protected void unInitReplyManager() {
        try {
            if (this.replyManager != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stopping JmsReplyManager: {} from processing replies from: {}", (Object)this.replyManager, (Object)(this.endpoint.getReplyTo() != null ? this.endpoint.getReplyTo() : "temporary queue"));
                }
                ServiceHelper.stopService((Object)this.replyManager);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            this.started.set(false);
        }
    }

    protected ReplyManager createReplyManager(String replyTo) throws Exception {
        QueueReplyManager replyManager = new QueueReplyManager(this.getEndpoint().getCamelContext());
        replyManager.setEndpoint(this.getEndpoint());
        String name = "JmsReplyManagerTimeoutChecker[" + replyTo + "]";
        ScheduledExecutorService replyManagerScheduledExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)name, name);
        replyManager.setScheduledExecutorService(replyManagerScheduledExecutorService);
        name = "JmsReplyManagerOnTimeout[" + replyTo + "]";
        int max = this.getEndpoint().getComponent().getReplyToOnTimeoutMaxConcurrentConsumers();
        if (max <= 0) {
            throw new IllegalArgumentException("The option replyToOnTimeoutMaxConcurrentConsumers must be >= 1");
        }
        ExecutorService replyManagerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newThreadPool((Object)replyManager, name, 0, max);
        replyManager.setOnTimeoutExecutorService(replyManagerExecutorService);
        ServiceHelper.startService((Object)replyManager);
        return replyManager;
    }

    protected ReplyManager createReplyManager() throws Exception {
        TemporaryQueueReplyManager temporaryQueueReplyManager = new TemporaryQueueReplyManager(this.getEndpoint().getCamelContext());
        temporaryQueueReplyManager.setEndpoint(this.getEndpoint());
        String name = "JmsReplyManagerTimeoutChecker[" + this.getEndpoint().getEndpointConfiguredDestinationName() + "]";
        ScheduledExecutorService replyManagerScheduledExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)name, name);
        temporaryQueueReplyManager.setScheduledExecutorService(replyManagerScheduledExecutorService);
        name = "JmsReplyManagerOnTimeout[" + this.getEndpoint().getEndpointConfiguredDestinationName() + "]";
        int max = this.getEndpoint().getComponent().getReplyToOnTimeoutMaxConcurrentConsumers();
        if (max <= 0) {
            throw new IllegalArgumentException("The option replyToOnTimeoutMaxConcurrentConsumers must be >= 1");
        }
        ExecutorService replyManagerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newThreadPool((Object)temporaryQueueReplyManager, name, 0, max);
        temporaryQueueReplyManager.setOnTimeoutExecutorService(replyManagerExecutorService);
        ServiceHelper.startService((Object)temporaryQueueReplyManager);
        return temporaryQueueReplyManager;
    }

    protected void testConnectionOnStartup() throws FailedToCreateProducerException {
        try {
            SjmsTemplate template = this.getInOnlyTemplate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Testing JMS Connection on startup for destination: {}", (Object)this.getEndpoint().getDestinationName());
            }
            Connection conn = template.getConnectionFactory().createConnection();
            SjmsHelper.closeConnection(conn);
            LOG.debug("Successfully tested JMS Connection on startup for destination: {}", (Object)this.getEndpoint().getDestinationName());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException((Endpoint)this.getEndpoint(), (Throwable)e);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            if (!this.endpoint.isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
                return this.processInOut(exchange, callback);
            }
            return this.processInOnly(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOut(final Exchange exchange, final AsyncCallback callback) {
        boolean generateFreshCorrId;
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJMSDestinationName", String.class);
        in.removeHeader("CamelJMSDestinationName");
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        this.initReplyManager();
        final long timeout = (Long)exchange.getIn().getHeader("CamelJmsRequestTimeout", (Object)this.endpoint.getRequestTimeout(), Long.TYPE);
        final String originalCorrelationId = (String)in.getHeader("JMSCorrelationID", String.class);
        boolean bl = generateFreshCorrId = ObjectHelper.isEmpty((String)originalCorrelationId) || originalCorrelationId.startsWith(GENERATED_CORRELATION_ID_PREFIX);
        if (generateFreshCorrId) {
            in.setHeader("JMSCorrelationID", (Object)(GENERATED_CORRELATION_ID_PREFIX + this.getUuidGenerator().generateUuid()));
        }
        MessageCreator messageCreator = new MessageCreator(){

            @Override
            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message answer = SjmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                String replyToOverride = SjmsProducer.this.endpoint.getReplyToOverride();
                Destination replyTo = replyToOverride != null ? SjmsProducer.this.resolveOrCreateDestination(replyToOverride, session) : SjmsProducer.this.replyManager.getReplyTo();
                if (replyTo == null) {
                    throw new RuntimeExchangeException("Failed to resolve replyTo destination", exchange);
                }
                JmsMessageHelper.setJMSReplyTo(answer, replyTo);
                String correlationId = SjmsProducer.this.determineCorrelationId(answer);
                SjmsProducer.this.replyManager.registerReply(SjmsProducer.this.replyManager, exchange, callback, originalCorrelationId, correlationId, timeout);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using {}: {}, JMSReplyTo destination: {}, with request timeout: {} ms.", new Object[]{"JMSCorrelationID", correlationId, replyTo, timeout});
                }
                LOG.trace("Created javax.jms.Message: {}", (Object)answer);
                return answer;
            }
        };
        try {
            this.doSend(exchange, true, destinationName, messageCreator);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    protected boolean processInOnly(final Exchange exchange, AsyncCallback callback) {
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJMSDestinationName", String.class);
        if (destinationName != null) {
            in.removeHeader("CamelJMSDestinationName");
        }
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        final String to = destinationName;
        MessageCreator messageCreator = new MessageCreator(){

            @Override
            public javax.jms.Message createMessage(Session session) throws JMSException {
                String replyTo;
                javax.jms.Message answer = SjmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                Object jmsReplyTo = JmsMessageHelper.getJMSReplyTo(answer);
                if (SjmsProducer.this.endpoint.isDisableReplyTo()) {
                    LOG.trace("ReplyTo is disabled on endpoint: {}", (Object)SjmsProducer.this.endpoint);
                    JmsMessageHelper.setJMSReplyTo(answer, null);
                } else if (jmsReplyTo == null && (jmsReplyTo = exchange.getIn().getHeader("JMSReplyTo", String.class)) == null) {
                    jmsReplyTo = SjmsProducer.this.endpoint.getReplyTo();
                }
                if (jmsReplyTo != null && !SjmsProducer.this.endpoint.isPreserveMessageQos() && !SjmsProducer.this.endpoint.isExplicitQosEnabled()) {
                    LOG.debug("Disabling JMSReplyTo: {} for destination: {}. Use preserveMessageQos=true to force Camel to keep the JMSReplyTo on endpoint: {}", new Object[]{jmsReplyTo, to, SjmsProducer.this.endpoint});
                    jmsReplyTo = null;
                }
                if (jmsReplyTo instanceof String) {
                    replyTo = (String)jmsReplyTo;
                    jmsReplyTo = SjmsProducer.this.resolveOrCreateDestination(replyTo, session);
                }
                replyTo = null;
                String replyToOverride = SjmsProducer.this.endpoint.getReplyToOverride();
                if (replyToOverride != null) {
                    replyTo = SjmsProducer.this.resolveOrCreateDestination(replyToOverride, session);
                } else if (jmsReplyTo != null) {
                    replyTo = jmsReplyTo;
                }
                if (replyTo != null) {
                    LOG.debug("Using JMSReplyTo destination: {}", (Object)replyTo);
                    JmsMessageHelper.setJMSReplyTo(answer, (Destination)replyTo);
                } else {
                    LOG.trace("Not using JMSReplyTo");
                    JmsMessageHelper.setJMSReplyTo(answer, null);
                }
                LOG.trace("Created javax.jms.Message: {}", (Object)answer);
                return answer;
            }
        };
        try {
            this.doSend(exchange, false, destinationName, messageCreator);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        this.setMessageId(exchange);
        callback.done(true);
        return true;
    }

    protected void setMessageId(Exchange exchange) {
        if (exchange.hasOut()) {
            SjmsMessage out = (SjmsMessage)((Object)exchange.getOut(SjmsMessage.class));
            try {
                if (out != null && out.getJmsMessage() != null) {
                    out.setMessageId(out.getJmsMessage().getJMSMessageID());
                }
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from outgoing JMS Message and set it into Camel's MessageId", (Throwable)e);
            }
        }
    }

    public SjmsTemplate getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(SjmsTemplate inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public SjmsTemplate getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(SjmsTemplate inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    protected Destination resolveOrCreateDestination(String destinationName, Session session) throws JMSException {
        boolean isPubSub = JmsMessageHelper.isTopicPrefix(destinationName) || !JmsMessageHelper.isQueuePrefix(destinationName) && this.endpoint.isTopic();
        String before = destinationName;
        destinationName = JmsMessageHelper.normalizeDestinationName(destinationName);
        LOG.trace("Normalized JMSReplyTo destination name {} -> {}", (Object)before, (Object)destinationName);
        return this.endpoint.getDestinationCreationStrategy().createDestination(session, destinationName, isPubSub);
    }

    protected String determineCorrelationId(javax.jms.Message message) throws JMSException {
        String cid = JmsMessageHelper.getJMSCorrelationID(message);
        if (ObjectHelper.isEmpty((String)cid)) {
            cid = JmsMessageHelper.getJMSMessageID(message);
        }
        return cid;
    }

    protected void doSend(Exchange exchange, boolean inOut, String destinationName, MessageCreator messageCreator) throws Exception {
        SjmsTemplate template;
        SjmsTemplate sjmsTemplate = template = inOut ? this.getInOutTemplate() : this.getInOnlyTemplate();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using {} jms template", (Object)(inOut ? "inOut" : "inOnly"));
        }
        template.send(exchange, destinationName, messageCreator, this.getEndpoint().isTopic());
    }
}

