/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.jms.IllegalHeaderException;
import org.apache.camel.component.sjms.jms.JmsConstants;
import org.apache.camel.component.sjms.jms.JmsMessageType;
import org.apache.camel.component.sjms.jms.KeyFormatStrategy;
import org.apache.camel.impl.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageHelper
implements JmsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageHelper.class);

    private JmsMessageHelper() {
    }

    public static Exchange createExchange(Message message, Endpoint endpoint) {
        Exchange exchange = endpoint.createExchange();
        return JmsMessageHelper.populateExchange(message, exchange, false, ((SjmsEndpoint)endpoint).getJmsKeyFormatStrategy());
    }

    public static Exchange populateExchange(Message message, Exchange exchange, boolean out, KeyFormatStrategy keyFormatStrategy) {
        try {
            JmsMessageHelper.setJmsMessageHeaders(message, exchange, out, keyFormatStrategy);
            if (message != null) {
                DefaultMessage bodyMessage = out ? (DefaultMessage)exchange.getOut() : (DefaultMessage)exchange.getIn();
                switch (JmsMessageHelper.discoverJmsMessageType(message)) {
                    case Bytes: {
                        BytesMessage bytesMessage = (BytesMessage)message;
                        if (bytesMessage.getBodyLength() > Integer.MAX_VALUE) {
                            LOGGER.warn("Length of BytesMessage is too long: {}", (Object)bytesMessage.getBodyLength());
                            return null;
                        }
                        byte[] result = new byte[(int)bytesMessage.getBodyLength()];
                        bytesMessage.readBytes(result);
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Bytes);
                        bodyMessage.setBody((Object)result);
                        break;
                    }
                    case Map: {
                        HashMap<String, Object> body = new HashMap<String, Object>();
                        MapMessage mapMessage = (MapMessage)message;
                        Enumeration names = mapMessage.getMapNames();
                        while (names.hasMoreElements()) {
                            String key = (String)names.nextElement();
                            Object value = mapMessage.getObject(key);
                            body.put(key, value);
                        }
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Map);
                        bodyMessage.setBody(body);
                        break;
                    }
                    case Object: {
                        ObjectMessage objMsg = (ObjectMessage)message;
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Object);
                        bodyMessage.setBody((Object)objMsg.getObject());
                        break;
                    }
                    case Text: {
                        TextMessage textMsg = (TextMessage)message;
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Text);
                        bodyMessage.setBody((Object)textMsg.getText());
                        break;
                    }
                    case Stream: {
                        Object obj;
                        StreamMessage streamMessage = (StreamMessage)message;
                        ArrayList<Object> list = new ArrayList<Object>();
                        while ((obj = streamMessage.readObject()) != null) {
                            list.add(obj);
                        }
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Stream);
                        bodyMessage.setBody(list);
                        break;
                    }
                    default: {
                        bodyMessage.setBody((Object)message);
                    }
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        return exchange;
    }

    public static Message createMessage(Exchange exchange, Session session, SjmsEndpoint endpoint) throws Exception {
        HashMap<String, Object> bodyHeaders;
        Object body;
        if (exchange.getOut().getBody() != null) {
            body = exchange.getOut().getBody();
            bodyHeaders = new HashMap<String, Object>(exchange.getOut().getHeaders());
        } else {
            body = exchange.getIn().getBody();
            bodyHeaders = new HashMap(exchange.getIn().getHeaders());
        }
        Message answer = JmsMessageHelper.createMessage(session, body, bodyHeaders, endpoint);
        return answer;
    }

    public static Message createMessage(Session session, Object payload, Map<String, Object> messageHeaders, SjmsEndpoint endpoint) throws Exception {
        return JmsMessageHelper.createMessage(session, payload, messageHeaders, endpoint.getJmsKeyFormatStrategy(), endpoint.getCamelContext().getTypeConverter());
    }

    private static Message createMessage(Session session, Object payload, Map<String, Object> messageHeaders, KeyFormatStrategy keyFormatStrategy, TypeConverter typeConverter) throws Exception {
        ObjectMessage answer = null;
        JmsMessageType messageType = JmsMessageHelper.discoverMessageTypeFromPayload(payload);
        try {
            switch (messageType) {
                case Bytes: {
                    BytesMessage bytesMessage = session.createBytesMessage();
                    byte[] bytesToWrite = (byte[])typeConverter.convertTo(byte[].class, payload);
                    bytesMessage.writeBytes(bytesToWrite);
                    answer = bytesMessage;
                    break;
                }
                case Map: {
                    MapMessage mapMessage = session.createMapMessage();
                    Map objMap = (Map)payload;
                    for (Map.Entry entry : objMap.entrySet()) {
                        mapMessage.setObject(entry.getKey().toString(), entry.getValue());
                    }
                    answer = mapMessage;
                    break;
                }
                case Object: {
                    ObjectMessage objectMessage = session.createObjectMessage();
                    objectMessage.setObject((Serializable)payload);
                    answer = objectMessage;
                    break;
                }
                case Text: {
                    TextMessage textMessage = session.createTextMessage();
                    String convertedText = (String)typeConverter.convertTo(String.class, payload);
                    textMessage.setText(convertedText);
                    answer = textMessage;
                    break;
                }
                case Stream: {
                    StreamMessage streamMessage = session.createStreamMessage();
                    Collection collection = (Collection)payload;
                    for (Object obj : collection) {
                        streamMessage.writeObject(obj);
                    }
                    answer = streamMessage;
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating a message of type: {}", (Object)messageType, (Object)e);
            throw e;
        }
        if (messageHeaders != null && !messageHeaders.isEmpty()) {
            answer = JmsMessageHelper.setJmsMessageHeaders((Message)answer, messageHeaders, keyFormatStrategy);
        }
        return answer;
    }

    private static Message setJmsMessageHeaders(Message jmsMessage, Map<String, Object> messageHeaders, KeyFormatStrategy keyFormatStrategy) throws IllegalHeaderException {
        HashMap<String, Object> headers = new HashMap<String, Object>(messageHeaders);
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerName.equalsIgnoreCase("JMSCorrelationID")) {
                if (headerValue == null) {
                    JmsMessageHelper.setCorrelationId(jmsMessage, null);
                    continue;
                }
                if (headerValue instanceof String) {
                    JmsMessageHelper.setCorrelationId(jmsMessage, (String)headerValue);
                    continue;
                }
                throw new IllegalHeaderException("The JMSCorrelationID must either be a String or null.  Found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase("JMSReplyTo")) {
                if (!(headerValue instanceof String)) continue;
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSType")) {
                if (headerValue == null) {
                    JmsMessageHelper.setMessageType(jmsMessage, null);
                    continue;
                }
                if (headerValue instanceof String) {
                    JmsMessageHelper.setMessageType(jmsMessage, (String)headerValue);
                    continue;
                }
                throw new IllegalHeaderException("The JMSType must either be a String or null.  Found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase("JMSPriority")) {
                if (headerValue instanceof Integer) {
                    try {
                        jmsMessage.setJMSPriority(((Integer)headerValue).intValue());
                        continue;
                    }
                    catch (JMSException e) {
                        throw new IllegalHeaderException("Failed to set the JMSPriority header. Cause: " + e.getLocalizedMessage(), e);
                    }
                }
                throw new IllegalHeaderException("The JMSPriority must be a Integer.  Type found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase("JMSDeliveryMode")) {
                try {
                    JmsMessageHelper.setJMSDeliveryMode(jmsMessage, headerValue);
                    continue;
                }
                catch (JMSException e) {
                    throw new IllegalHeaderException("Failed to set the JMSDeliveryMode header. Cause: " + e.getLocalizedMessage(), e);
                }
            }
            if (headerName.equalsIgnoreCase("JMSExpiration")) {
                if (headerValue instanceof Long) {
                    try {
                        jmsMessage.setJMSExpiration(((Long)headerValue).longValue());
                        continue;
                    }
                    catch (JMSException e) {
                        throw new IllegalHeaderException("Failed to set the JMSExpiration header. Cause: " + e.getLocalizedMessage(), e);
                    }
                }
                throw new IllegalHeaderException("The JMSExpiration must be a Long.  Type found: " + headerValue.getClass().getName());
            }
            LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
            if (headerName.equalsIgnoreCase("JMSDestination") || headerName.equalsIgnoreCase("JMSMessageID") || headerName.equalsIgnoreCase("JMSTimestamp") || headerName.equalsIgnoreCase("JMSRedelivered")) {
                LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
                continue;
            }
            if (headerValue instanceof JmsMessageType) continue;
            String encodedName = keyFormatStrategy.encodeKey(headerName);
            try {
                JmsMessageHelper.setProperty(jmsMessage, encodedName, headerValue);
            }
            catch (JMSException e) {
                throw new IllegalHeaderException("Failed to set the header " + encodedName + " header. Cause: " + e.getLocalizedMessage(), e);
            }
        }
        return jmsMessage;
    }

    public static Exchange setJmsMessageHeaders(Message jmsMessage, Exchange exchange, boolean out, KeyFormatStrategy keyFormatStrategy) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (jmsMessage != null) {
            try {
                headers.put("JMSCorrelationID", jmsMessage.getJMSCorrelationID());
                headers.put("JMSDeliveryMode", jmsMessage.getJMSDeliveryMode());
                headers.put("JMSDestination", jmsMessage.getJMSDestination());
                headers.put("JMSExpiration", jmsMessage.getJMSExpiration());
                headers.put("JMSMessageID", jmsMessage.getJMSMessageID());
                headers.put("JMSPriority", jmsMessage.getJMSPriority());
                headers.put("JMSRedelivered", jmsMessage.getJMSRedelivered());
                headers.put("JMSTimestamp", jmsMessage.getJMSTimestamp());
                headers.put("JMSReplyTo", JmsMessageHelper.getJMSReplyTo(jmsMessage));
                headers.put("JMSType", JmsMessageHelper.getJMSType(jmsMessage));
                headers.put("JMSXGroupID", jmsMessage.getStringProperty("JMSXGroupID"));
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            Enumeration enumeration = jmsMessage.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (JmsMessageHelper.hasIllegalHeaderKey(key)) {
                    throw new IllegalHeaderException("Header " + key + " is not a legal JMS header name value");
                }
                Object value = jmsMessage.getObjectProperty(key);
                String decodedName = keyFormatStrategy.decodeKey(key);
                headers.put(decodedName, value);
            }
        }
        if (out) {
            exchange.getOut().setHeaders(headers);
        } else {
            exchange.getIn().setHeaders(headers);
        }
        return exchange;
    }

    public static String getJMSType(Message message) {
        try {
            return message.getJMSType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJMSDeliveryMode(Message message, Object deliveryMode) throws JMSException {
        Integer mode;
        if (deliveryMode instanceof String) {
            String s = (String)deliveryMode;
            if ("PERSISTENT".equalsIgnoreCase(s)) {
                mode = 2;
            } else if ("NON_PERSISTENT".equalsIgnoreCase(s)) {
                mode = 1;
            } else {
                Integer value = null;
                try {
                    value = Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (value == null) throw new IllegalArgumentException("Unknown delivery mode with value: " + deliveryMode);
                mode = value;
            }
        } else {
            if (!(deliveryMode instanceof Integer)) throw new IllegalArgumentException("Unable to convert the given delivery mode of type " + deliveryMode.getClass().getName() + " with value: " + deliveryMode);
            mode = (Integer)deliveryMode;
        }
        message.setJMSDeliveryMode(mode.intValue());
    }

    public static void setMessageType(Message message, String type) {
        try {
            message.setJMSType(type);
        }
        catch (JMSException e) {
            LOGGER.debug("Error setting the message type: {}", (Object)type, (Object)e);
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException e) {
            LOGGER.debug("Error setting the correlationId: {}", (Object)correlationId, (Object)e);
        }
    }

    public static void setJMSReplyTo(Message message, Destination replyTo) {
        try {
            message.setJMSReplyTo(replyTo);
        }
        catch (Exception e) {
            LOGGER.debug("Error setting the correlationId: {}", (Object)replyTo.toString());
        }
    }

    public static Destination getJMSReplyTo(Message message) {
        try {
            return message.getJMSReplyTo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            jmsMessage.setObjectProperty(name, null);
        } else if (value instanceof Byte) {
            jmsMessage.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof String) {
            jmsMessage.setStringProperty(name, (String)value);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static JmsMessageType discoverMessageTypeFromPayload(Object payload) {
        JmsMessageType answer = payload == null ? JmsMessageType.Message : (byte[].class.isInstance(payload) ? JmsMessageType.Bytes : (Map.class.isInstance(payload) ? JmsMessageType.Map : (Collection.class.isInstance(payload) ? JmsMessageType.Stream : (InputStream.class.isInstance(payload) ? JmsMessageType.Bytes : (ByteBuffer.class.isInstance(payload) ? JmsMessageType.Bytes : (File.class.isInstance(payload) ? JmsMessageType.Bytes : (Reader.class.isInstance(payload) ? JmsMessageType.Text : (String.class.isInstance(payload) ? JmsMessageType.Text : (CharBuffer.class.isInstance(payload) ? JmsMessageType.Text : (char[].class.isInstance(payload) ? JmsMessageType.Text : (Character.class.isInstance(payload) ? JmsMessageType.Text : (Serializable.class.isInstance(payload) ? JmsMessageType.Object : JmsMessageType.Message))))))))))));
        return answer;
    }

    public static JmsMessageType discoverJmsMessageType(Message message) {
        JmsMessageType answer = message != null ? (BytesMessage.class.isInstance(message) ? JmsMessageType.Bytes : (MapMessage.class.isInstance(message) ? JmsMessageType.Map : (TextMessage.class.isInstance(message) ? JmsMessageType.Text : (StreamMessage.class.isInstance(message) ? JmsMessageType.Stream : (ObjectMessage.class.isInstance(message) ? JmsMessageType.Object : JmsMessageType.Message))))) : JmsMessageType.Message;
        return answer;
    }

    private static boolean hasIllegalHeaderKey(String key) {
        return key == null || key.isEmpty() || key.contains(".") || key.contains("-");
    }
}

