/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sjms.SjmsComponent;
import org.apache.camel.component.sjms.SjmsConsumer;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DefaultDestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.KeyFormatStrategy;
import org.apache.camel.component.sjms.jms.SessionAcknowledgementType;
import org.apache.camel.component.sjms.producer.InOnlyProducer;
import org.apache.camel.component.sjms.producer.InOutProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sjms", syntax="sjms:destinationType:destinationName", consumerClass=SjmsConsumer.class, label="messaging")
public class SjmsEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @UriPath(enums="queue,topic", defaultValue="queue")
    private String destinationType;
    @UriPath
    @Metadata(required="true")
    private String destinationName;
    @UriParam(defaultValue="true")
    private boolean synchronous = true;
    @UriParam
    private boolean transacted;
    @UriParam
    private String namedReplyTo;
    @UriParam(defaultValue="AUTO_ACKNOWLEDGE")
    private SessionAcknowledgementType acknowledgementMode = SessionAcknowledgementType.AUTO_ACKNOWLEDGE;
    private boolean topic;
    @UriParam(defaultValue="1")
    private int sessionCount = 1;
    @UriParam(defaultValue="1")
    private int producerCount = 1;
    @UriParam(defaultValue="1")
    private int consumerCount = 1;
    @UriParam(defaultValue="-1")
    private long ttl = -1L;
    @UriParam(defaultValue="true")
    private boolean persistent = true;
    @UriParam
    private String durableSubscriptionId;
    @UriParam(defaultValue="5000")
    private long responseTimeOut = 5000L;
    @UriParam
    private String messageSelector;
    @UriParam(defaultValue="-1")
    private int transactionBatchCount = -1;
    @UriParam(defaultValue="5000")
    private long transactionBatchTimeout = 5000L;
    @UriParam(defaultValue="false")
    private boolean asyncStartListener;
    @UriParam(defaultValue="false")
    private boolean asyncStopListener;
    @UriParam(defaultValue="true")
    private boolean prefillPool = true;
    @UriParam
    private TransactionCommitStrategy transactionCommitStrategy;
    @UriParam
    private DestinationCreationStrategy destinationCreationStrategy = new DefaultDestinationCreationStrategy();

    public SjmsEndpoint() {
    }

    public SjmsEndpoint(String uri, Component component) {
        super(uri, component);
        if (this.getEndpointUri().contains("://queue:")) {
            this.topic = false;
        } else if (this.getEndpointUri().contains("://topic:")) {
            this.topic = true;
        } else {
            throw new IllegalArgumentException("Endpoint URI unsupported: " + uri);
        }
        this.destinationName = this.getEndpointUri().substring(this.getEndpointUri().lastIndexOf(":") + 1);
        if (this.destinationName.contains("?")) {
            this.destinationName = this.destinationName.substring(0, this.destinationName.lastIndexOf("?"));
        }
    }

    public SjmsComponent getComponent() {
        return (SjmsComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        SjmsProducer producer = this.getExchangePattern().equals((Object)ExchangePattern.InOnly) ? new InOnlyProducer((Endpoint)this) : new InOutProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SjmsConsumer answer = new SjmsConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public ConnectionResource getConnectionResource() {
        return this.getComponent().getConnectionResource();
    }

    public HeaderFilterStrategy getSjmsHeaderFilterStrategy() {
        return this.getComponent().getHeaderFilterStrategy();
    }

    public KeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.getComponent().getKeyFormatStrategy();
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public SessionAcknowledgementType getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(SessionAcknowledgementType acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTopic() {
        return this.topic;
    }

    @Deprecated
    public int getSessionCount() {
        return this.sessionCount;
    }

    @Deprecated
    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public int getProducerCount() {
        return this.producerCount;
    }

    public void setProducerCount(int producerCount) {
        this.producerCount = producerCount;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getDurableSubscriptionId() {
        return this.durableSubscriptionId;
    }

    public void setDurableSubscriptionId(String durableSubscriptionId) {
        this.durableSubscriptionId = durableSubscriptionId;
    }

    public long getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setResponseTimeOut(long responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionBatchCount() {
        return this.transactionBatchCount;
    }

    public void setTransactionBatchCount(int transactionBatchCount) {
        this.transactionBatchCount = transactionBatchCount;
    }

    public long getTransactionBatchTimeout() {
        return this.transactionBatchTimeout;
    }

    public void setTransactionBatchTimeout(long transactionBatchTimeout) {
        if (transactionBatchTimeout >= 1000L) {
            this.transactionBatchTimeout = transactionBatchTimeout;
        }
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy transactionCommitStrategy) {
        this.transactionCommitStrategy = transactionCommitStrategy;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        if (transacted) {
            this.setAcknowledgementMode(SessionAcknowledgementType.SESSION_TRANSACTED);
        }
        this.transacted = transacted;
    }

    public String getNamedReplyTo() {
        return this.namedReplyTo;
    }

    public void setNamedReplyTo(String namedReplyTo) {
        this.namedReplyTo = namedReplyTo;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public boolean isAsyncStopListener() {
        return this.asyncStopListener;
    }

    public boolean isPrefillPool() {
        return this.prefillPool;
    }

    public void setPrefillPool(boolean prefillPool) {
        this.prefillPool = prefillPool;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }
}

