/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.shiro.crypto.cipher.CipherService;
import org.apache.shiro.lang.util.ByteSource;

public final class ShiroSecurityHelper {
    private static Pattern pattern = Pattern.compile("(\\d+):(.+)");

    private ShiroSecurityHelper() {
    }

    public static ByteSource encrypt(ShiroSecurityToken securityToken, byte[] passPhrase, CipherService cipherService) {
        byte[] data = ShiroSecurityHelper.serialize(securityToken);
        return cipherService.encrypt(data, passPhrase);
    }

    static byte[] serialize(ShiroSecurityToken token) {
        StringBuilder sb = new StringBuilder().append(token.getUsername().length()).append(":").append(token.getUsername()).append(token.getPassword() != null ? token.getPassword() : "");
        return sb.toString().getBytes();
    }

    public static ShiroSecurityToken deserialize(byte[] data) {
        String text = new String(data);
        Matcher matcher = pattern.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalStateException("Can not deserialize security token - token is probably corrupted.");
        }
        int length = Integer.parseInt(matcher.group(1));
        String username = matcher.group(2).substring(0, length);
        String password = matcher.group(2).substring(length);
        return new ShiroSecurityToken(username, password);
    }
}

