/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaConsumer
extends DefaultConsumer
implements Runnable,
ShutdownAware,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(SedaConsumer.class);
    private final AtomicInteger taskCount = new AtomicInteger();
    private volatile CountDownLatch latch;
    private volatile boolean shutdownPending;
    private volatile boolean forceShutdown;
    private ExecutorService executor;
    private final int pollTimeout;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.pollTimeout = endpoint.getPollTimeout();
    }

    public SedaEndpoint getEndpoint() {
        return (SedaEndpoint)super.getEndpoint();
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        if (this.getEndpoint().isPurgeWhenStopping()) {
            this.getEndpoint().purgeQueue();
        }
        return this.getEndpoint().getQueue().size();
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        if (suspendOnly) {
            LOG.debug("Skip preparing to shutdown as consumer is being suspended");
            return;
        }
        this.shutdownPending = true;
        this.forceShutdown = forced;
        if (this.latch != null) {
            LOG.debug("Preparing to shutdown, waiting for {} consumer threads to complete.", (Object)this.latch.getCount());
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isRunAllowed() {
        if (this.forceShutdown) {
            return false;
        }
        if (this.isSuspending() || this.isSuspended()) {
            return true;
        }
        return super.isRunAllowed();
    }

    @Override
    public void run() {
        this.taskCount.incrementAndGet();
        try {
            this.doRun();
        }
        finally {
            this.taskCount.decrementAndGet();
            this.latch.countDown();
            LOG.debug("Ending this polling consumer thread, there are still {} consumer threads left.", (Object)this.latch.getCount());
        }
    }

    protected void doRun() {
        BlockingQueue<Exchange> queue = this.getEndpoint().getQueue();
        while (queue != null && this.isRunAllowed()) {
            if (this.getEndpoint().getCamelContext().getStatus().isStarting()) {
                LOG.trace("CamelContext is starting so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            if (this.isSuspending() || this.isSuspended() || this.isStarting()) {
                if (this.shutdownPending && queue.isEmpty()) {
                    LOG.trace("Consumer is suspended and shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                    break;
                }
                LOG.trace("Consumer is suspended so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            Exchange exchange = null;
            try {
                exchange = queue.poll(this.pollTimeout, TimeUnit.MILLISECONDS);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Polled queue {} with timeout {} ms. -> {}", new Object[]{ObjectHelper.getIdentityHashCode(queue), this.pollTimeout, exchange});
                }
                if (exchange != null) {
                    try {
                        Exchange target = exchange;
                        this.prepareExchange(target);
                        AsyncCallback callback = doneSync -> {
                            if (target.getException() != null) {
                                this.getExceptionHandler().handleException("Error processing exchange", target, (Throwable)target.getException());
                            }
                        };
                        this.sendToConsumers(target, callback);
                    }
                    catch (Exception e) {
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                    }
                    continue;
                }
                if (!this.shutdownPending || !queue.isEmpty()) continue;
                LOG.trace("Shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                break;
            }
            catch (InterruptedException e) {
                LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if (exchange != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                    continue;
                }
                this.getExceptionHandler().handleException((Throwable)e);
            }
        }
    }

    protected void prepareExchange(Exchange exchange) {
        exchange.getExchangeExtension().setFromEndpoint((Endpoint)this.getEndpoint());
        exchange.getExchangeExtension().setFromRouteId(this.getRouteId());
    }

    protected void sendToConsumers(Exchange exchange, AsyncCallback callback) throws Exception {
        int size = this.getEndpoint().getConsumers().size();
        if (size > 1 && !this.getEndpoint().isMultipleConsumersSupported()) {
            throw new IllegalStateException("Multiple consumers for the same endpoint is not allowed: " + this.getEndpoint());
        }
        if (this.getEndpoint().isMultipleConsumersSupported()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Multicasting to {} consumers for Exchange: {}", (Object)size, (Object)exchange);
            }
            List completions = exchange.getExchangeExtension().handoverCompletions();
            AsyncProcessor mp = this.getEndpoint().getConsumerMulticastProcessor();
            ObjectHelper.notNull((Object)mp, (String)"ConsumerMulticastProcessor", (Object)this);
            mp.process(exchange, doneSync -> {
                try {
                    UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, (List)completions);
                }
                finally {
                    callback.done(doneSync);
                }
            });
        } else {
            this.getAsyncProcessor().process(exchange, callback);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.latch = new CountDownLatch(this.getEndpoint().getConcurrentConsumers());
        this.shutdownPending = false;
        this.forceShutdown = false;
        this.setupTasks();
        this.getEndpoint().onStarted(this);
    }

    protected void doSuspend() throws Exception {
        this.getEndpoint().onStopped(this);
    }

    protected void doResume() throws Exception {
        this.getEndpoint().onStarted(this);
    }

    protected void doStop() throws Exception {
        if (this.getEndpoint().isPurgeWhenStopping()) {
            this.getEndpoint().purgeQueue();
        }
        this.getEndpoint().onStopped(this);
        this.shutdownExecutor();
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        this.shutdownExecutor();
    }

    private void shutdownExecutor() {
        if (this.executor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private void setupTasks() {
        int poolSize = this.getEndpoint().getConcurrentConsumers();
        if (this.executor == null) {
            this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.getEndpoint().getEndpointUri(), poolSize);
        }
        int tasks = poolSize - this.taskCount.get();
        LOG.debug("Creating {} consumer tasks with poll timeout {} ms.", (Object)tasks, (Object)this.pollTimeout);
        for (int i = 0; i < tasks; ++i) {
            this.executor.execute(this);
        }
    }
}

