/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron.processor;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import org.apache.camel.component.schematron.exception.SchematronConfigException;
import org.apache.camel.component.schematron.processor.SchematronProcessor;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SchematronProcessorFactory {
    private SchematronProcessorFactory() {
        throw new IllegalStateException();
    }

    public static SchematronProcessor newSchematronEngine(Templates rules) {
        try {
            return new SchematronProcessor(SchematronProcessorFactory.getXMLReader(), rules);
        }
        catch (Exception e) {
            throw new SchematronConfigException(e);
        }
    }

    private static XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory fac = SAXParserFactory.newInstance();
        fac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        fac.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        fac.setFeature("http://xml.org/sax/features/external-general-entities", false);
        fac.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        fac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        fac.setValidating(false);
        SAXParser parser = fac.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        return reader;
    }
}

