/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron.processor;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.util.ObjectHelper;

public class ClassPathURIResolver
implements URIResolver {
    private final String rulesDir;
    private final URIResolver clientUriResolver;

    public ClassPathURIResolver(String rulesDir, URIResolver clientUriResolver) {
        this.rulesDir = rulesDir;
        this.clientUriResolver = clientUriResolver;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream stream = ObjectHelper.loadResourceAsStream((String)this.rulesDir.concat("/").concat(href), (ClassLoader)this.getClass().getClassLoader());
        if (stream != null) {
            return new StreamSource(stream);
        }
        if (this.clientUriResolver != null) {
            return this.clientUriResolver.resolve(href, base);
        }
        return new StreamSource(stream);
    }
}

