/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import com.salesforce.eventbus.protobuf.ReplayPreset;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.PubSubDeserializeType;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.client.PubSubApiClient;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;

public class PubSubApiConsumer
extends DefaultConsumer {
    private final String topic;
    private final ReplayPreset initialReplayPreset;
    private String initialReplayId;
    private final SalesforceEndpoint endpoint;
    private final int batchSize;
    private final PubSubDeserializeType deserializeType;
    private Class<?> pojoClass;
    private PubSubApiClient pubSubClient;
    private Map<String, Class<?>> eventClassMap;
    private boolean usePlainTextConnection = false;

    public PubSubApiConsumer(SalesforceEndpoint endpoint, Processor processor) throws ClassNotFoundException {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.topic = endpoint.getTopicName();
        this.initialReplayPreset = endpoint.getConfiguration().getReplayPreset();
        this.initialReplayId = endpoint.getPubSubReplayId();
        if (this.initialReplayPreset == ReplayPreset.CUSTOM && this.initialReplayId == null) {
            throw new IllegalArgumentException("pubSubReplayId option is required if ReplayPreset is CUSTOM.");
        }
        this.batchSize = endpoint.getConfiguration().getPubSubBatchSize();
        this.deserializeType = endpoint.getConfiguration().getPubSubDeserializeType();
        String pojoClassName = endpoint.getConfiguration().getPubSubPojoClass();
        if (pojoClassName != null) {
            this.pojoClass = endpoint.getCamelContext().getClassResolver().resolveMandatoryClass(pojoClassName);
        }
    }

    public void processEvent(Object recordObj, String replayId) {
        Exchange exchange = this.createExchange(true);
        Message in = exchange.getIn();
        in.setBody(recordObj);
        in.setHeader("CamelSalesforcePubSubReplayId", (Object)replayId);
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.getComponent().getLoginConfig().isLazyLogin()) {
            throw new SalesforceException("Lazy login is not supported by salesforce consumers.", null);
        }
        this.eventClassMap = this.endpoint.getComponent().getEventClassMap();
        this.pubSubClient = new PubSubApiClient(this.endpoint.getComponent().getSession(), this.endpoint.getComponent().getLoginConfig(), this.endpoint.getComponent().getPubSubHost(), this.endpoint.getComponent().getPubSubPort(), this.endpoint.getConfiguration().getBackoffIncrement(), this.endpoint.getConfiguration().getMaxBackoff(), this.endpoint.getComponent().isPubsubAllowUseSystemProxy());
        this.pubSubClient.setUsePlainTextConnection(this.usePlainTextConnection);
        ServiceHelper.startService((Service)this.pubSubClient);
        this.pubSubClient.subscribe(this, this.initialReplayPreset, this.initialReplayId, true);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.pubSubClient);
        super.doStop();
    }

    public String getTopic() {
        return this.topic;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public PubSubDeserializeType getDeserializeType() {
        return this.deserializeType;
    }

    public Map<String, Class<?>> getEventClassMap() {
        return this.eventClassMap;
    }

    public Class<?> getPojoClass() {
        return this.pojoClass;
    }

    public void setUsePlainTextConnection(boolean usePlainTextConnection) {
        this.usePlainTextConnection = usePlainTextConnection;
    }

    public void updateInitialReplayId(String initialReplayId) {
        this.initialReplayId = initialReplayId;
    }
}

