/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.TypeReferences;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AsyncReportResults;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.RecentReport;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportDescription;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportInstance;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.SyncReportResults;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.AnalyticsApiClient;
import org.eclipse.jetty.client.BytesRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;

public class DefaultAnalyticsApiClient
extends AbstractClientBase
implements AnalyticsApiClient {
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String INCLUDE_DETAILS_QUERY_PARAM = "?includeDetails=";
    private ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public DefaultAnalyticsApiClient(String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
    }

    @Override
    public void getRecentReports(Map<String, List<String>> headers, final AnalyticsApiClient.RecentReportsResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.GET, this.reportsUrl(), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                List<RecentReport> recentReports = null;
                if (response != null) {
                    try {
                        recentReports = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, TypeReferences.RECENT_REPORT_LIST_TYPE);
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(recentReports, headers, ex);
            }
        });
    }

    @Override
    public void getReportDescription(String reportId, Map<String, List<String>> headers, final AnalyticsApiClient.ReportDescriptionResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.GET, this.reportsDescribeUrl(reportId), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                ReportDescription reportDescription = null;
                try {
                    reportDescription = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, ReportDescription.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportDescription, headers, ex);
            }
        });
    }

    @Override
    public void executeSyncReport(String reportId, Boolean includeDetails, ReportMetadata reportMetadata, Map<String, List<String>> headers, final AnalyticsApiClient.ReportResultsResponseCallback callback) {
        boolean useGet = reportMetadata == null;
        final Request request = this.getRequest(useGet ? HttpMethod.GET : HttpMethod.POST, this.reportsUrl(reportId, includeDetails), headers);
        if (!useGet) {
            try {
                HashMap<String, ReportMetadata> input = new HashMap<String, ReportMetadata>();
                input.put("reportMetadata", reportMetadata);
                this.marshalRequest(input, request);
            }
            catch (SalesforceException e) {
                callback.onResponse(null, Collections.emptyMap(), e);
                return;
            }
        }
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                SyncReportResults reportResults = null;
                try {
                    reportResults = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, SyncReportResults.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportResults, headers, ex);
            }
        });
    }

    @Override
    public void executeAsyncReport(String reportId, Boolean includeDetails, ReportMetadata reportMetadata, Map<String, List<String>> headers, final AnalyticsApiClient.ReportInstanceResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.POST, this.reportInstancesUrl(reportId, includeDetails), headers);
        if (reportMetadata != null) {
            try {
                HashMap<String, ReportMetadata> input = new HashMap<String, ReportMetadata>();
                input.put("reportMetadata", reportMetadata);
                this.marshalRequest(input, request);
            }
            catch (SalesforceException e) {
                callback.onResponse(null, Collections.emptyMap(), e);
                return;
            }
        }
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                ReportInstance reportInstance = null;
                try {
                    reportInstance = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, ReportInstance.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportInstance, headers, ex);
            }
        });
    }

    @Override
    public void getReportInstances(String reportId, Map<String, List<String>> headers, final AnalyticsApiClient.ReportInstanceListResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.GET, this.reportInstancesUrl(reportId), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                List<ReportInstance> reportInstances = null;
                if (response != null) {
                    try {
                        reportInstances = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, TypeReferences.REPORT_INSTANCE_LIST_TYPE);
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(reportInstances, headers, ex);
            }
        });
    }

    @Override
    public void getReportResults(String reportId, String instanceId, Map<String, List<String>> headers, final AnalyticsApiClient.ReportResultsResponseCallback callback) {
        final Request request = this.getRequest(HttpMethod.GET, this.reportInstancesUrl(reportId, instanceId), headers);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                AsyncReportResults reportResults = null;
                try {
                    reportResults = DefaultAnalyticsApiClient.this.unmarshalResponse(response, request, AsyncReportResults.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportResults, headers, ex);
            }
        });
    }

    private String reportsUrl() {
        return this.instanceUrl + "/services/data/v" + this.version + "/analytics/reports";
    }

    private String reportsDescribeUrl(String reportId) {
        return this.reportsUrl(reportId) + "/describe";
    }

    private String reportsUrl(String reportId) {
        return this.reportsUrl() + "/" + reportId;
    }

    private String reportsUrl(String reportId, Boolean includeDetails) {
        return includeDetails == null ? this.reportsUrl(reportId) : this.reportsUrl(reportId) + INCLUDE_DETAILS_QUERY_PARAM + includeDetails;
    }

    private String reportInstancesUrl(String reportId) {
        return this.reportsUrl(reportId) + "/instances";
    }

    private String reportInstancesUrl(String reportId, Boolean includeDetails) {
        return includeDetails == null ? this.reportInstancesUrl(reportId) : this.reportInstancesUrl(reportId) + INCLUDE_DETAILS_QUERY_PARAM + includeDetails;
    }

    private String reportInstancesUrl(String reportId, String instanceId) {
        return this.reportInstancesUrl(reportId) + "/" + instanceId;
    }

    @Override
    protected void setAccessToken(Request request) {
        request.headers(mutable -> mutable.add(new HttpField(HttpHeader.AUTHORIZATION, TOKEN_PREFIX + this.accessToken)));
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        int statusCode = response.getStatus();
        try {
            if (responseContent != null) {
                List<RestError> errors = this.readErrorsFrom(responseContent, this.objectMapper);
                if (statusCode == 404) {
                    return new NoSuchSObjectException(errors);
                }
                return new SalesforceException(errors, statusCode);
            }
        }
        catch (IOException e) {
            String msg = "Unexpected Error parsing JSON error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        String message = String.format("Unexpected error: %s, with content: %s", response.getReason(), responseContent);
        return new SalesforceException(message, statusCode);
    }

    @Override
    protected void doHttpRequest(Request request, AbstractClientBase.ClientResponseCallback callback) {
        this.setAccessToken(request);
        request.headers(mutable -> mutable.add(new HttpField(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8")));
        request.headers(mutable -> mutable.add(new HttpField(HttpHeader.ACCEPT, "application/json;charset=utf-8")));
        request.headers(mutable -> mutable.add(new HttpField(HttpHeader.ACCEPT_CHARSET, StandardCharsets.UTF_8.name())));
        super.doHttpRequest(request, callback);
    }

    private void marshalRequest(Object input, Request request) throws SalesforceException {
        try {
            request.body((Request.Content)new BytesRequestContent((byte[][])new byte[][]{this.objectMapper.writeValueAsBytes(input)}));
        }
        catch (Exception e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
    }

    private <T> T unmarshalResponse(InputStream response, Request request, TypeReference<T> responseTypeReference) throws SalesforceException {
        try {
            return (T)this.objectMapper.readValue(response, responseTypeReference);
        }
        catch (Exception e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
    }

    private <T> T unmarshalResponse(InputStream response, Request request, Class<T> responseClass) throws SalesforceException {
        if (response == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(response, responseClass);
        }
        catch (Exception e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getURI(), e.getMessage()), e);
        }
    }
}

