/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.streaming;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class ReplayExtension
implements ClientSession.Extension {
    private static final String EXTENSION_NAME = "replay";
    private static final String EVENT_KEY = "event";
    private static final String REPLAY_ID_KEY = "replayId";
    private final ConcurrentMap<String, Long> dataMap = new ConcurrentHashMap<String, Long>();
    private final AtomicBoolean supported = new AtomicBoolean();

    public void setReplayIdIfAbsent(String channelName, long replayId) {
        this.dataMap.putIfAbsent(channelName, replayId);
    }

    public void setReplayId(String channelName, long replayId) {
        this.dataMap.put(channelName, replayId);
    }

    public boolean rcv(ClientSession session, Message.Mutable message) {
        Long replayId = ReplayExtension.getReplayId(message);
        if (this.supported.get() && replayId != null) {
            try {
                String channel = ReplayExtension.topicWithoutQueryString(message.getChannel());
                this.dataMap.put(channel, replayId);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                Map ext = message.getExt(false);
                this.supported.set(ext != null && Boolean.TRUE.equals(ext.get(EXTENSION_NAME)));
                break;
            }
        }
        return true;
    }

    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                message.getExt(true).put(EXTENSION_NAME, Boolean.TRUE);
                break;
            }
            case "/meta/subscribe": {
                if (!this.supported.get()) break;
                message.getExt(true).put(EXTENSION_NAME, this.dataMap);
                break;
            }
        }
        return true;
    }

    private static Long getReplayId(Message.Mutable message) {
        Map data = message.getDataAsMap();
        Optional<Long> optional = ReplayExtension.resolve(() -> (Long)((Map)data.get(EVENT_KEY)).get(REPLAY_ID_KEY));
        return optional.orElse(null);
    }

    private static <T> Optional<T> resolve(Supplier<T> resolver) {
        try {
            T result = resolver.get();
            return Optional.ofNullable(result);
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private static String topicWithoutQueryString(String fullTopic) {
        return fullTopic.split("\\?")[0];
    }
}

