/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.composite.ReferenceId;

public final class SObjectTreeResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean hasErrors;
    private final List<ReferenceId> results;

    @JsonCreator
    public SObjectTreeResponse(@JsonProperty(value="hasErrors") boolean hasErrors, @JsonProperty(value="results") List<ReferenceId> results) {
        this.hasErrors = hasErrors;
        this.results = Optional.ofNullable(results).orElse(Collections.emptyList());
    }

    public List<RestError> getAllErrors() {
        return this.results.stream().flatMap(r -> r.getErrors().stream()).collect(Collectors.toList());
    }

    public List<ReferenceId> getResults() {
        return this.results;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }
}

