/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.PickListValue;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;
import org.apache.camel.component.salesforce.codegen.AbstractSalesforceExecution;
import org.apache.camel.component.salesforce.codegen.Defaults;
import org.apache.camel.component.salesforce.codegen.ObjectDescriptions;
import org.apache.camel.impl.engine.DefaultBeanIntrospection;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.util.StringHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateExecution
extends AbstractSalesforceExecution {
    public static final Map<String, String> DEFAULT_TYPES = GenerateExecution.defineLookupMap();
    private static final Set<String> BASE_FIELDS = GenerateExecution.defineBaseFields();
    private static final String BASE64BINARY = "base64Binary";
    private static final List<String> BLACKLISTED_PROPERTIES = Arrays.asList("PicklistValues", "ChildRelationships");
    private static final Pattern FIELD_DEFINITION_PATTERN = Pattern.compile("\\w+\\.{1}\\w+");
    private static final String JAVA_EXT = ".java";
    private static final String MULTIPICKLIST = "multipicklist";
    private static final String PACKAGE_NAME_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String PICKLIST = "picklist";
    private static final String SOBJECT_PICKLIST_VM = "/sobject-picklist.vm";
    private static final String SOBJECT_POJO_OPTIONAL_VM = "/sobject-pojo-optional.vm";
    private static final String SOBJECT_POJO_VM = "/sobject-pojo.vm";
    private static final String SOBJECT_QUERY_RECORDS_OPTIONAL_VM = "/sobject-query-records-optional.vm";
    private static final String SOBJECT_QUERY_RECORDS_VM = "/sobject-query-records.vm";
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger((String)GenerateExecution.class.getName());
    Map<String, String> customTypes;
    ObjectDescriptions descriptions;
    VelocityEngine engine = this.createVelocityEngine();
    String includePattern;
    File outputDirectory;
    String packageName;
    String childRelationshipNameSuffix;
    Properties enumerationOverrideProperties = new Properties();
    String[] picklistToEnums;
    String[] picklistToStrings;
    Boolean useStringsForPicklists;
    private String excludePattern;
    private String[] excludes;
    private String[] includes;
    private final Map<String, Set<String>> picklistsEnumToSObject = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> picklistsStringToSObject = new HashMap<String, Set<String>>();
    private final Map<String, String> types = new HashMap<String, String>(DEFAULT_TYPES);
    private boolean useOptionals;

    public void parsePicklistToEnums() {
        GenerateExecution.parsePicklistOverrideArgs(this.picklistToEnums, this.picklistsEnumToSObject);
    }

    public void parsePicklistToStrings() {
        GenerateExecution.parsePicklistOverrideArgs(this.picklistToStrings, this.picklistsStringToSObject);
    }

    public void processDescription(File pkgDir, SObjectDescription description, GeneratorUtility utility, Set<String> sObjectNames) throws IOException {
        OutputStreamWriter writer;
        this.useStringsForPicklists = this.useStringsForPicklists == null ? Boolean.FALSE : this.useStringsForPicklists;
        this.parsePicklistToEnums();
        this.parsePicklistToStrings();
        this.childRelationshipNameSuffix = this.childRelationshipNameSuffix != null ? this.childRelationshipNameSuffix : "";
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)this.packageName);
        context.put("utility", (Object)utility);
        context.put("esc", StringEscapeUtils.class);
        context.put("desc", (Object)description);
        context.put("useStringsForPicklists", (Object)this.useStringsForPicklists);
        context.put("childRelationshipNameSuffix", (Object)this.childRelationshipNameSuffix);
        String pojoFileName = description.getName() + JAVA_EXT;
        File pojoFile = new File(pkgDir, pojoFileName);
        context.put("sObjectNames", sObjectNames);
        context.put("descriptions", (Object)this.descriptions);
        try (OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(pojoFile), StandardCharsets.UTF_8);){
            Template pojoTemplate = this.engine.getTemplate(SOBJECT_POJO_VM, UTF_8);
            pojoTemplate.merge((Context)context, (Writer)writer2);
        }
        if (this.useOptionals) {
            String optionalFileName = description.getName() + "Optional.java";
            File optionalFile = new File(pkgDir, optionalFileName);
            try (OutputStreamWriter writer3 = new OutputStreamWriter((OutputStream)new FileOutputStream(optionalFile), StandardCharsets.UTF_8);){
                Template optionalTemplate = this.engine.getTemplate(SOBJECT_POJO_OPTIONAL_VM, UTF_8);
                optionalTemplate.merge((Context)context, (Writer)writer3);
            }
        }
        if (!this.useStringsForPicklists.booleanValue() || this.picklistToEnums != null && this.picklistToEnums.length > 0) {
            for (SObjectField field : description.getFields()) {
                if (!utility.isPicklist(field) && !utility.isMultiSelectPicklist(field)) continue;
                String enumName = utility.enumTypeName(description.getName(), field.getName());
                String enumFileName = enumName + JAVA_EXT;
                File enumFile = new File(pkgDir, enumFileName);
                context.put("sObjectName", (Object)description.getName());
                context.put("field", (Object)field);
                context.put("enumName", (Object)enumName);
                Template enumTemplate = this.engine.getTemplate(SOBJECT_PICKLIST_VM, UTF_8);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(enumFile), StandardCharsets.UTF_8);
                try {
                    enumTemplate.merge((Context)context, (Writer)writer);
                }
                finally {
                    ((Writer)writer).close();
                }
            }
        }
        String queryRecordsFileName = "QueryRecords" + description.getName() + JAVA_EXT;
        File queryRecordsFile = new File(pkgDir, queryRecordsFileName);
        Template queryTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_VM, UTF_8);
        try (OutputStreamWriter writer4 = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsFile), StandardCharsets.UTF_8);){
            queryTemplate.merge((Context)context, (Writer)writer4);
        }
        if (this.useOptionals) {
            String queryRecordsOptionalFileName = "QueryRecords" + description.getName() + "Optional.java";
            File queryRecordsOptionalFile = new File(pkgDir, queryRecordsOptionalFileName);
            Template queryRecordsOptionalTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_OPTIONAL_VM, UTF_8);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsOptionalFile), StandardCharsets.UTF_8);
            try {
                queryRecordsOptionalTemplate.merge((Context)context, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
    }

    @Override
    protected void executeWithClient() throws Exception {
        File pkgDir;
        this.descriptions = new ObjectDescriptions(this.getRestClient(), this.getResponseTimeout(), this.includes, this.includePattern, this.excludes, this.excludePattern, this.getLog());
        if (!(this.engine.resourceExists(SOBJECT_POJO_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_VM) && this.engine.resourceExists(SOBJECT_POJO_OPTIONAL_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_OPTIONAL_VM))) {
            throw new RuntimeException("Velocity templates not found");
        }
        if (!this.packageName.matches(PACKAGE_NAME_PATTERN)) {
            throw new RuntimeException("Invalid package name " + this.packageName);
        }
        if (this.outputDirectory.getAbsolutePath().contains("$")) {
            this.outputDirectory = new File("generated-sources/camel-salesforce");
        }
        if (!(pkgDir = new File(this.outputDirectory, this.packageName.trim().replace('.', File.separatorChar))).exists() && !pkgDir.mkdirs()) {
            throw new RuntimeException("Unable to create " + String.valueOf(pkgDir));
        }
        this.getLog().info("Generating Java Classes...");
        Set<String> sObjectNames = StreamSupport.stream(this.descriptions.fetched().spliterator(), false).map(d -> d.getName()).collect(Collectors.toSet());
        GeneratorUtility utility = new GeneratorUtility();
        for (SObjectDescription description : this.descriptions.fetched()) {
            if (Defaults.IGNORED_OBJECTS.contains(description.getName())) continue;
            try {
                this.processDescription(pkgDir, description, utility, sObjectNames);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to generate source files for: " + description.getName(), e);
            }
        }
        this.getLog().info(String.format("Successfully generated %s Java Classes", this.descriptions.count() * 2));
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    public void setup() {
        if (this.customTypes != null) {
            this.types.putAll(this.customTypes);
        }
    }

    private VelocityEngine createVelocityEngine() {
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("resource.loaders", "cloader");
        velocityProperties.setProperty("resource.loader.cloader.class", ClasspathResourceLoader.class.getName());
        velocityProperties.setProperty("runtime.log.name", LOG.getName());
        return new VelocityEngine(velocityProperties);
    }

    private static Set<String> defineBaseFields() {
        HashSet<String> baseFields = new HashSet<String>();
        for (Field field : AbstractSObjectBase.class.getDeclaredFields()) {
            baseFields.add(field.getName());
        }
        return baseFields;
    }

    private static Map<String, String> defineLookupMap() {
        String[][] typeMap = new String[][]{{"ID", "String"}, {"string", "String"}, {"integer", "java.math.BigInteger"}, {"int", "Integer"}, {"long", "Long"}, {"short", "Short"}, {"decimal", "java.math.BigDecimal"}, {"float", "Float"}, {"double", "Double"}, {"boolean", "Boolean"}, {"byte", "Byte"}, {BASE64BINARY, "String"}, {"unsignedInt", "Long"}, {"unsignedShort", "Integer"}, {"unsignedByte", "Short"}, {"dateTime", "java.time.ZonedDateTime"}, {"time", "java.time.OffsetTime"}, {"date", "java.time.LocalDate"}, {"g", "java.time.ZonedDateTime"}, {"anyType", "String"}, {"address", "org.apache.camel.component.salesforce.api.dto.Address"}, {"location", "org.apache.camel.component.salesforce.api.dto.GeoLocation"}, {"RelationshipReferenceTo", "String"}};
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        for (String[] entry : typeMap) {
            lookupMap.put(entry[0], entry[1]);
        }
        return Collections.unmodifiableMap(lookupMap);
    }

    private static void parsePicklistOverrideArgs(String[] picklists, Map<String, Set<String>> picklistsToSObject) {
        if (picklists != null && picklists.length > 0) {
            for (String picklist : picklists) {
                if (!FIELD_DEFINITION_PATTERN.matcher(picklist).matches()) {
                    throw new IllegalArgumentException("Invalid format provided for picklistFieldToEnum value - allowed format SObjectName.FieldName");
                }
                String[] strings = picklist.split("\\.");
                picklistsToSObject.putIfAbsent(strings[0], new HashSet());
                picklistsToSObject.get(strings[0]).add(strings[1]);
            }
        }
    }

    public void setCustomTypes(Map<String, String> customTypes) {
        this.customTypes = customTypes;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setChildRelationshipNameSuffix(String childRelationshipNameSuffix) {
        this.childRelationshipNameSuffix = childRelationshipNameSuffix;
    }

    public void setEnumerationOverrideProperties(Properties enumerationOverrideProperties) {
        this.enumerationOverrideProperties = enumerationOverrideProperties;
    }

    public void setPicklistToEnums(String[] picklistToEnums) {
        this.picklistToEnums = picklistToEnums;
    }

    public void setPicklistToStrings(String[] picklistToStrings) {
        this.picklistToStrings = picklistToStrings;
    }

    public void setUseStringsForPicklists(Boolean useStringsForPicklists) {
        this.useStringsForPicklists = useStringsForPicklists;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setUseOptionals(boolean useOptionals) {
        this.useOptionals = useOptionals;
    }

    public void setDescriptions(ObjectDescriptions descriptions) {
        this.descriptions = descriptions;
    }

    public class GeneratorUtility {
        private ArrayDeque<String> stack;
        private final Map<String, AtomicInteger> varNames = new HashMap<String, AtomicInteger>();
        private final BeanIntrospection bi = new DefaultBeanIntrospection();

        public String current() {
            return this.stack.peek();
        }

        public String enumTypeName(String sObjectName, String name) {
            return sObjectName + "_" + (name.endsWith("__c") ? name.substring(0, name.length() - 3) : name) + "Enum";
        }

        public List<SObjectField> externalIdsOf(String name) {
            return GenerateExecution.this.descriptions.externalIdsOf(name);
        }

        public String getEnumConstant(String objectName, String fieldName, String picklistValue) {
            String key = String.join((CharSequence)".", objectName, fieldName, picklistValue);
            if (GenerateExecution.this.enumerationOverrideProperties.containsKey(key)) {
                return GenerateExecution.this.enumerationOverrideProperties.get(key).toString();
            }
            StringBuilder result = new StringBuilder();
            boolean changed = false;
            if (!Character.isJavaIdentifierStart(picklistValue.charAt(0))) {
                result.append("_");
                changed = true;
            }
            for (char c : picklistValue.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
                changed = true;
            }
            return changed ? result.toString().toUpperCase() : picklistValue.toUpperCase();
        }

        public String getFieldType(SObjectDescription description, SObjectField field) {
            if (this.isPicklist(field)) {
                if (Boolean.TRUE.equals(GenerateExecution.this.useStringsForPicklists)) {
                    if (GenerateExecution.this.picklistsEnumToSObject.containsKey(description.getName()) && GenerateExecution.this.picklistsEnumToSObject.get(description.getName()).contains(field.getName())) {
                        return this.enumTypeName(description.getName(), field.getName());
                    }
                    return String.class.getName();
                }
                if (GenerateExecution.this.picklistsStringToSObject.containsKey(description.getName()) && GenerateExecution.this.picklistsStringToSObject.get(description.getName()).contains(field.getName())) {
                    return String.class.getName();
                }
                return this.enumTypeName(description.getName(), field.getName());
            }
            if (this.isMultiSelectPicklist(field)) {
                if (Boolean.TRUE.equals(GenerateExecution.this.useStringsForPicklists)) {
                    if (GenerateExecution.this.picklistsEnumToSObject.containsKey(description.getName()) && GenerateExecution.this.picklistsEnumToSObject.get(description.getName()).contains(field.getName())) {
                        return this.enumTypeName(description.getName(), field.getName()) + "[]";
                    }
                    return String.class.getName() + "[]";
                }
                if (GenerateExecution.this.picklistsStringToSObject.containsKey(description.getName()) && GenerateExecution.this.picklistsStringToSObject.get(description.getName()).contains(field.getName())) {
                    return String.class.getName() + "[]";
                }
                return this.enumTypeName(description.getName(), field.getName()) + "[]";
            }
            String soapType = field.getSoapType();
            String lookupType = soapType.substring(soapType.indexOf(58) + 1);
            String type = GenerateExecution.this.types.get(lookupType);
            if (type == null) {
                GenerateExecution.this.getLog().warn(String.format("Unsupported field type `%s` in field `%s` of object `%s`", soapType, field.getName(), description.getName()));
                GenerateExecution.this.getLog().debug("Currently known types:\n " + GenerateExecution.this.types.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\n")));
            }
            return type;
        }

        public String getLookupRelationshipName(SObjectField field) {
            return StringHelper.notEmpty((String)field.getRelationshipName(), (String)"relationshipName", (Object)field.getName());
        }

        public List<PickListValue> getUniqueValues(SObjectField field) {
            if (field.getPicklistValues().isEmpty()) {
                return field.getPicklistValues();
            }
            ArrayList<PickListValue> result = new ArrayList<PickListValue>();
            HashSet<String> literals = new HashSet<String>();
            for (PickListValue listValue : field.getPicklistValues()) {
                String value = listValue.getValue();
                if (literals.contains(value)) continue;
                literals.add(value);
                result.add(listValue);
            }
            literals.clear();
            Collections.sort(result, (o1, o2) -> o1.getValue().compareTo(o2.getValue()));
            return result;
        }

        public boolean hasDescription(String name) {
            return GenerateExecution.this.descriptions.hasDescription(name);
        }

        public boolean hasMultiSelectPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isMultiSelectPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean includeList(List<?> list, String propertyName) {
            return !list.isEmpty() && !BLACKLISTED_PROPERTIES.contains(propertyName);
        }

        public boolean isBlobField(SObjectField field) {
            String soapType = field.getSoapType();
            return GenerateExecution.BASE64BINARY.equals(soapType.substring(soapType.indexOf(58) + 1));
        }

        public boolean isExternalId(SObjectField field) {
            return field.isExternalId();
        }

        public boolean isLookup(SObjectField field) {
            return "reference".equals(field.getType());
        }

        public boolean isMultiSelectPicklist(SObjectField field) {
            return GenerateExecution.MULTIPICKLIST.equals(field.getType());
        }

        public boolean isPicklist(SObjectField field) {
            return GenerateExecution.PICKLIST.equals(field.getType());
        }

        public boolean isPrimitiveOrBoxed(Object object) {
            Class<?> clazz = object.getClass();
            boolean isWholeNumberWrapper = Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz);
            boolean isFloatingPointWrapper = Double.class.equals(clazz) || Float.class.equals(clazz);
            boolean isWrapper = isWholeNumberWrapper || isFloatingPointWrapper || Boolean.class.equals(clazz) || Character.class.equals(clazz);
            boolean isPrimitive = clazz.isPrimitive();
            return isPrimitive || isWrapper;
        }

        public boolean notBaseField(String name) {
            return !BASE_FIELDS.contains(name);
        }

        public boolean notNull(Object val) {
            return val != null;
        }

        public void pop() {
            this.stack.pop();
        }

        public String javaSafeString(String val) {
            return StringEscapeUtils.escapeJava((String)val);
        }

        public Set<Map.Entry<String, Object>> propertiesOf(Object object) {
            TreeMap properties = new TreeMap();
            this.bi.getProperties(object, properties, null, false);
            Function<Map.Entry, String> keyMapper = e -> StringUtils.capitalize((String)((String)e.getKey()));
            Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
            BinaryOperator mergeFunction = (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            };
            Supplier<Map> mapSupplier = LinkedHashMap::new;
            return properties.entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)).entrySet();
        }

        public void push(String additional) {
            this.stack.push(additional);
        }

        public void start(String initial) {
            this.stack = new ArrayDeque();
            this.stack.push(initial);
            this.varNames.clear();
        }

        public String variableName(String given) {
            String base = StringUtils.uncapitalize((String)given);
            AtomicInteger counter = this.varNames.computeIfAbsent(base, k -> new AtomicInteger());
            return base + counter.incrementAndGet();
        }
    }
}

