/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.codegen;

import com.salesforce.eventbus.protobuf.TopicInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.camel.component.salesforce.codegen.AbstractSalesforceExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePubSubExecution
extends AbstractSalesforceExecution {
    private String[] topics;
    private File outputDirectory;

    @Override
    protected void executeWithClient() throws Exception {
        for (String topicName : this.topics) {
            TopicInfo topicInfo = this.getPubSubApiClient().getTopicInfo(topicName);
            String schemaJson = this.getPubSubApiClient().getSchemaJson(topicInfo.getSchemaId());
            File schemaFile = File.createTempFile("schema", ".json", this.outputDirectory);
            schemaFile.deleteOnExit();
            Files.writeString(schemaFile.toPath(), (CharSequence)schemaJson, new OpenOption[0]);
            SpecificCompiler.compileSchema((File)schemaFile, (File)this.outputDirectory);
        }
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected Logger getLog() {
        return LoggerFactory.getLogger(GeneratePubSubExecution.class);
    }
}

