/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;

public final class RssUtils {
    private RssUtils() {
    }

    public static SyndFeed createFeed(String feedUri) throws Exception {
        return RssUtils.createFeed(feedUri, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            SyndFeed syndFeed = RssUtils.createSyndFeed(feedUri);
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private static SyndFeed createSyndFeed(String feedUri) throws IOException, FeedException {
        try (XmlReader reader = new XmlReader(URI.create(feedUri).toURL());){
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)reader);
            return syndFeed;
        }
    }
}

