/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.ParserResult;
import org.apache.camel.parser.helper.ParserCommon;
import org.apache.camel.parser.roaster.AnonymousMethodSource;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.URISupport;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ReturnStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Statement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TextBlock;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class CamelJavaParserHelper {
    private CamelJavaParserHelper() {
    }

    public static MethodSource<JavaClassSource> findConfigureMethod(JavaClassSource clazz) {
        MethodSource<JavaClassSource> method = clazz.getMethod("configure");
        if (method != null && method.isPublic() && method.getParameters().isEmpty() && method.getReturnType().isType("void")) {
            return method;
        }
        method = CamelJavaParserHelper.findCreateRouteBuilderMethod(clazz);
        if (method != null) {
            return CamelJavaParserHelper.findConfigureMethodInCreateRouteBuilder(clazz, method);
        }
        return null;
    }

    public static List<MethodSource<JavaClassSource>> findInlinedConfigureMethods(JavaClassSource clazz) {
        ArrayList<MethodSource<JavaClassSource>> answer = new ArrayList<MethodSource<JavaClassSource>>();
        List methods = clazz.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                MethodSource<JavaClassSource> builder;
                if (!method.isPublic() || method.getParameters() != null && !method.getParameters().isEmpty() || method.getReturnType() != null && !method.getReturnType().isType("void") || (builder = CamelJavaParserHelper.findConfigureMethodInCreateRouteBuilder(clazz, (MethodSource<JavaClassSource>)method)) == null) continue;
                answer.add(builder);
            }
        }
        return answer;
    }

    private static MethodSource<JavaClassSource> findCreateRouteBuilderMethod(JavaClassSource clazz) {
        MethodSource method = clazz.getMethod("createRouteBuilder");
        if (method != null && (method.isPublic() || method.isProtected()) && method.getParameters().isEmpty()) {
            return method;
        }
        return null;
    }

    private static MethodSource<JavaClassSource> findConfigureMethodInCreateRouteBuilder(JavaClassSource clazz, MethodSource<JavaClassSource> method) {
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        Block block = md.getBody();
        if (block != null) {
            List statements = block.statements();
            for (Object statement : statements) {
                ClassInstanceCreation cic;
                boolean isRouteBuilder;
                Expression exp = CamelJavaParserHelper.getExpression((Statement)statement);
                if (!(exp instanceof ClassInstanceCreation) || !(isRouteBuilder = CamelJavaParserHelper.isRouteBuilderCheck(cic = (ClassInstanceCreation)exp)) || cic.getAnonymousClassDeclaration() == null) continue;
                List body = cic.getAnonymousClassDeclaration().bodyDeclarations();
                for (Object line : body) {
                    MethodDeclaration amd;
                    if (!(line instanceof MethodDeclaration) || !"configure".equals((amd = (MethodDeclaration)line).getName().toString())) continue;
                    return new AnonymousMethodSource(clazz, amd);
                }
            }
        }
        return null;
    }

    private static boolean isRouteBuilderCheck(ClassInstanceCreation cic) {
        boolean isRouteBuilder = false;
        Type type = cic.getType();
        if (type instanceof SimpleType) {
            SimpleType st = (SimpleType)type;
            isRouteBuilder = "RouteBuilder".equals(st.getName().toString());
        }
        return isRouteBuilder;
    }

    private static Expression getExpression(Statement statement) {
        ExpressionStatement es;
        Statement stmt = statement;
        Expression exp = null;
        if (stmt instanceof ReturnStatement) {
            ReturnStatement rs = (ReturnStatement)stmt;
            exp = rs.getExpression();
        } else if (stmt instanceof ExpressionStatement && (exp = (es = (ExpressionStatement)stmt).getExpression()) instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            for (Object arg : mi.arguments()) {
                if (!(arg instanceof ClassInstanceCreation)) continue;
                exp = (Expression)arg;
                break;
            }
        }
        return exp;
    }

    public static List<ParserResult> parseCamelRouteIds(MethodSource<JavaClassSource> method) {
        return CamelJavaParserHelper.doParseCamelUris(method, true, false, true, false, true);
    }

    public static List<ParserResult> parseCamelConsumerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, true, false, strings, fields, false);
    }

    public static List<ParserResult> parseCamelProducerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, false, true, strings, fields, false);
    }

    private static List<ParserResult> doParseCamelUris(MethodSource<JavaClassSource> method, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        MethodDeclaration md;
        Block block;
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        if (method != null && (block = (md = (MethodDeclaration)method.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> uris = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression((JavaClassSource)method.getOrigin(), block, exp, uris, consumers, producers, strings, fields, routeIdsOnly);
                if (uris.isEmpty()) continue;
                Collections.reverse(uris);
                answer.addAll(uris);
            }
        }
        return answer;
    }

    private static void parseExpression(JavaClassSource clazz, Block block, Expression exp, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelUris(clazz, block, mi, uris, consumers, producers, strings, fields, routeIdsOnly);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(clazz, block, exp, uris, consumers, producers, strings, fields, routeIdsOnly);
        }
    }

    private static void doParseCamelUris(JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields, boolean routeIdsOnly) {
        List args;
        String name = mi.getName().getIdentifier();
        if (routeIdsOnly) {
            if ("routeId".equals(name)) {
                CamelJavaParserHelper.addRouteId(clazz, block, mi, uris, name);
            }
            return;
        }
        if (consumers) {
            if ("from".equals(name) && (args = mi.arguments()) != null) {
                CamelJavaParserHelper.iterateOverArguments(clazz, block, uris, strings, fields, args, name);
            }
            if ("fromF".equals(name) || "interceptFrom".equals(name) || "pollEnrich".equals(name) || "poll".equals(name)) {
                CamelJavaParserHelper.parseFirstArgument(clazz, block, mi, uris, strings, fields, name);
            }
        }
        if (producers) {
            if (("to".equals(name) || "toD".equals(name)) && (args = mi.arguments()) != null) {
                CamelJavaParserHelper.iterateOverArguments(clazz, block, uris, strings, fields, args, name);
            }
            if ("toF".equals(name) || "enrich".equals(name) || "wireTap".equals(name)) {
                CamelJavaParserHelper.parseFirstArgument(clazz, block, mi, uris, strings, fields, name);
            }
        }
    }

    private static void addRouteId(JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> uris, String name) {
        List args = mi.arguments();
        if (args != null) {
            for (Object arg : args) {
                String routeId;
                if (!CamelJavaParserHelper.isValidArgument(arg) || Strings.isNullOrEmpty((String)(routeId = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)arg)))) continue;
                int position = ((Expression)arg).getStartPosition();
                int len = ((Expression)arg).getLength();
                uris.add(new ParserResult(name, position, len, routeId));
            }
        }
    }

    private static void parseFirstArgument(JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> uris, boolean strings, boolean fields, String name) {
        List args = mi.arguments();
        if (args != null && !args.isEmpty()) {
            CamelJavaParserHelper.parseFirstArgument(clazz, block, uris, strings, fields, args, name);
        }
    }

    private static void parseFirstArgument(JavaClassSource clazz, Block block, List<ParserResult> uris, boolean strings, boolean fields, List<?> args, String name) {
        Object arg = args.get(0);
        if (CamelJavaParserHelper.isValidArgument(arg)) {
            CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
        }
    }

    private static void iterateOverArguments(JavaClassSource clazz, Block block, List<ParserResult> uris, boolean strings, boolean fields, List<?> args, String name) {
        for (Object arg : args) {
            if (!CamelJavaParserHelper.isValidArgument(arg)) continue;
            CamelJavaParserHelper.extractEndpointUriFromArgument(name, clazz, block, uris, arg, strings, fields);
        }
    }

    private static boolean isValidArgument(Object arg) {
        QualifiedName qn;
        String name;
        if (arg instanceof BooleanLiteral) {
            return false;
        }
        return !(arg instanceof QualifiedName) || !(name = (qn = (QualifiedName)arg).getFullyQualifiedName()).startsWith("ExchangePattern");
    }

    private static void extractEndpointUriFromArgument(String node, JavaClassSource clazz, Block block, List<ParserResult> uris, Object arg, boolean strings, boolean fields) {
        FieldSource<JavaClassSource> field;
        if (strings) {
            String uri = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)arg);
            if (!Strings.isNullOrEmpty((String)(uri = URISupport.textBlockToSingleLine((String)uri)))) {
                int position = ((Expression)arg).getStartPosition();
                int len = ((Expression)arg).getLength();
                if ("fromF".equals(node) || "toF".equals(node)) {
                    uri = uri.replace("%s", "{{%s}}");
                    uri = uri.replace("%d", "{{%d}}");
                    uri = uri.replace("%b", "{{%b}}");
                }
                uris.add(new ParserResult(node, position, len, uri));
                return;
            }
        }
        if (fields && arg instanceof SimpleName && (field = ParserCommon.getField(clazz, block, (SimpleName)arg)) != null) {
            AnnotationSource annotation = field.getAnnotation("org.apache.camel.cdi.Uri");
            if (annotation == null) {
                annotation = field.getAnnotation("org.apache.camel.EndpointInject");
            }
            if (annotation != null) {
                Expression exp = CamelJavaParserHelper.extractExpression(annotation.getInternal());
                String uri = CamelJavaParserHelper.getLiteralValue(clazz, block, exp);
                if (!Strings.isNullOrEmpty((String)uri)) {
                    int position = ((SimpleName)arg).getStartPosition();
                    int len = ((SimpleName)arg).getLength();
                    uris.add(new ParserResult(node, position, len, uri));
                }
            } else {
                Expression exp;
                String uri;
                Object fi = field.getInternal();
                if (fi instanceof VariableDeclaration && !Strings.isNullOrEmpty((String)(uri = CamelJavaParserHelper.getLiteralValue(clazz, block, exp = ((VariableDeclaration)fi).getInitializer())))) {
                    int position = ((VariableDeclaration)fi).getStartPosition();
                    int len = ((VariableDeclaration)fi).getLength();
                    uris.add(new ParserResult(node, position, len, uri));
                }
            }
        }
        uris.add(new ParserResult(node, -1, -1, arg.toString(), false));
    }

    private static Expression extractExpression(Object annotation) {
        Expression exp = (Expression)annotation;
        return ParserCommon.evalExpression(exp);
    }

    public static List<ParserResult> parseCamelLanguageExpressions(MethodSource<JavaClassSource> method, String language) {
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        Block block = md.getBody();
        if (block != null) {
            for (Object statement : block.statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> expressions = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression(null, (JavaClassSource)method.getOrigin(), block, exp, expressions, language);
                if (expressions.isEmpty()) continue;
                Collections.reverse(expressions);
                answer.addAll(expressions);
            }
        }
        return answer;
    }

    private static void parseExpression(String node, JavaClassSource clazz, Block block, Expression exp, List<ParserResult> expressions, String language) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelLanguage(node, clazz, block, mi, expressions, language);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(node, clazz, block, exp, expressions, language);
        }
    }

    private static void doParseCamelLanguage(String node, JavaClassSource clazz, Block block, MethodInvocation mi, List<ParserResult> expressions, String language) {
        Object arg;
        String exp;
        List args;
        String name = mi.getName().getIdentifier();
        if (language.equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && !Strings.isNullOrEmpty((String)(exp = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)(arg = args.get(0)))))) {
            String pName;
            ASTNode o;
            ASTNode p;
            List list;
            boolean predicate = false;
            Expression parent = mi.getExpression();
            if (parent == null && (list = mi.arguments()) != null && list.size() == 1 && (p = (o = (ASTNode)list.get(0)).getParent()) instanceof MethodInvocation && language.equals(pName = ((MethodInvocation)p).getName().getIdentifier())) {
                parent = (Expression)p.getParent();
            }
            if (parent instanceof MethodInvocation) {
                MethodInvocation emi = (MethodInvocation)parent;
                String parentName = emi.getName().getIdentifier();
                predicate = CamelJavaParserHelper.isLanguagePredicate(parentName);
            }
            int position = ((Expression)arg).getStartPosition();
            int len = ((Expression)arg).getLength();
            ParserResult result = new ParserResult(node, position, len, exp);
            result.setPredicate(predicate);
            expressions.add(result);
        }
        if ((args = mi.arguments()) != null) {
            for (Object arg2 : args) {
                if (!(arg2 instanceof MethodInvocation)) continue;
                MethodInvocation ami = (MethodInvocation)arg2;
                CamelJavaParserHelper.doParseCamelLanguage(node, clazz, block, ami, expressions, language);
            }
        }
    }

    private static boolean isLanguagePredicate(String name) {
        if (name == null) {
            return false;
        }
        return ParserCommon.isCommonPredicate(name);
    }

    public static String getLiteralValue(JavaClassSource clazz, Block block, Expression expression) {
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            return stringLiteral.getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            return String.valueOf(booleanLiteral.booleanValue());
        }
        if (expression instanceof NumberLiteral) {
            NumberLiteral numberLiteral = (NumberLiteral)expression;
            return numberLiteral.getToken();
        }
        if (expression instanceof TextBlock) {
            TextBlock textBlock = (TextBlock)expression;
            return textBlock.getLiteralValue();
        }
        if (expression instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)expression;
            String name = methodInvocation.getName().getIdentifier();
            return "{{" + name + "}}";
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)expression;
            String name = qn.getFullyQualifiedName();
            return "{{" + name + "}}";
        }
        if (expression instanceof SimpleName) {
            FieldSource<JavaClassSource> field = ParserCommon.getField(clazz, block, (SimpleName)expression);
            if (field != null) {
                if (field.getAnnotations() != null) {
                    for (Annotation ann : field.getAnnotations()) {
                        Expression exp;
                        boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                        if (!valid || (exp = CamelJavaParserHelper.extractExpression(ann.getInternal())) == null) continue;
                        return CamelJavaParserHelper.getLiteralValue(clazz, block, exp);
                    }
                }
                return CamelJavaParserHelper.endpointTypeCheck(clazz, block, field);
            }
            String fieldName = ((SimpleName)expression).getIdentifier();
            return "{{" + fieldName + "}}";
        }
        if (expression instanceof InfixExpression) {
            InfixExpression ie = (InfixExpression)expression;
            return CamelJavaParserHelper.getValueFromExpression(clazz, block, ie);
        }
        return null;
    }

    private static String getValueFromExpression(JavaClassSource clazz, Block block, InfixExpression ie) {
        Object answer = null;
        if (InfixExpression.Operator.PLUS.equals(ie.getOperator())) {
            List extended;
            boolean numeric;
            String val1 = CamelJavaParserHelper.getLiteralValue(clazz, block, ie.getLeftOperand());
            String val2 = CamelJavaParserHelper.getLiteralValue(clazz, block, ie.getRightOperand());
            boolean bl = numeric = ParserCommon.isNumericOperator(clazz, block, ie.getLeftOperand()) && ParserCommon.isNumericOperator(clazz, block, ie.getRightOperand());
            if (numeric) {
                long num1 = val1 != null ? Long.parseLong(val1) : 0L;
                long num2 = val2 != null ? Long.parseLong(val2) : 0L;
                answer = Long.toString(num1 + num2);
            } else {
                answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
            }
            if (!((String)answer).isEmpty() && (extended = ie.extendedOperands()) != null) {
                StringBuilder answerBuilder = new StringBuilder((String)answer);
                for (Object ext : extended) {
                    String val3 = CamelJavaParserHelper.getLiteralValue(clazz, block, (Expression)ext);
                    if (numeric) {
                        long num3 = val3 != null ? Long.parseLong(val3) : 0L;
                        long num = Long.parseLong(answerBuilder.toString());
                        answerBuilder = new StringBuilder(Long.toString(num + num3));
                        continue;
                    }
                    answerBuilder.append(val3 != null ? val3 : "");
                }
                answer = answerBuilder.toString();
            }
        }
        return answer;
    }

    static String endpointTypeCheck(JavaClassSource clazz, Block block, FieldSource<JavaClassSource> field) {
        if ("Endpoint".equals(field.getType().getSimpleName())) {
            MethodInvocation mi;
            List args;
            VariableDeclarationFragment vdf = (VariableDeclarationFragment)field.getInternal();
            Expression expression = vdf.getInitializer();
            if (expression instanceof MethodInvocation && (args = (mi = (MethodInvocation)expression).arguments()) != null && !args.isEmpty()) {
                expression = (Expression)args.get(0);
                return CamelJavaParserHelper.getLiteralValue(clazz, block, expression);
            }
        } else {
            VariableDeclarationFragment vdf = (VariableDeclarationFragment)field.getInternal();
            Expression expression = vdf.getInitializer();
            if (expression == null) {
                return "{{" + field.getName() + "}}";
            }
            return CamelJavaParserHelper.getLiteralValue(clazz, block, expression);
        }
        return null;
    }
}

