/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.rocketmq.RocketMQAclUtils;
import org.apache.camel.component.rocketmq.RocketMQEndpoint;
import org.apache.camel.component.rocketmq.SendFailedException;
import org.apache.camel.component.rocketmq.reply.ReplyManager;
import org.apache.camel.component.rocketmq.reply.RocketMQReplyManagerSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQProducer
extends DefaultAsyncProducer {
    public static final String GENERATE_MESSAGE_KEY_PREFIX = "camel-rocketmq-";
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQProducer.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private DefaultMQProducer mqProducer;
    private ReplyManager replyManager;

    public RocketMQProducer(RocketMQEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public RocketMQEndpoint getEndpoint() {
        return (RocketMQEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            LOG.trace("Exchange Pattern {}", (Object)exchange.getPattern());
            if (exchange.getPattern().isOutCapable()) {
                return this.processInOut(exchange, callback);
            }
            return this.processInOnly(exchange, callback);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOut(final Exchange exchange, final AsyncCallback callback) throws RemotingException, MQClientException, InterruptedException, NoTypeConversionAvailableException {
        Message in = exchange.getIn();
        org.apache.rocketmq.common.message.Message message = new org.apache.rocketmq.common.message.Message();
        message.setTopic((String)in.getHeader("CamelRockerMQOverrideTopicName", () -> this.getEndpoint().getTopicName(), String.class));
        message.setTags((String)in.getHeader("CamelRockerMQOverrideTag", () -> this.getEndpoint().getSendTag(), String.class));
        message.setBody((byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, in.getBody()));
        message.setKeys((String)in.getHeader("CamelRockerMQOverrideMessageKey", (Object)"", String.class));
        this.initReplyManager();
        final String generateKey = GENERATE_MESSAGE_KEY_PREFIX + this.getEndpoint().getCamelContext().getUuidGenerator().generateUuid();
        message.setKeys(Arrays.asList(Optional.ofNullable(message.getKeys()).orElse(""), generateKey));
        LOG.debug("RocketMQ Producer sending {}", (Object)message);
        this.mqProducer.send(message, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                if (!SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus())) {
                    exchange.setException((Throwable)new SendFailedException(sendResult.toString()));
                    callback.done(false);
                    return;
                }
                if (RocketMQProducer.this.replyManager == null) {
                    LOG.warn("replyToTopic not set! Will not wait for reply.");
                    callback.done(false);
                    return;
                }
                RocketMQProducer.this.replyManager.registerReply(RocketMQProducer.this.replyManager, exchange, callback, generateKey, RocketMQProducer.this.getEndpoint().getRequestTimeoutMillis());
            }

            public void onException(Throwable e) {
                try {
                    RocketMQProducer.this.replyManager.cancelMessageKey(generateKey);
                    exchange.setException(e);
                }
                finally {
                    callback.done(false);
                }
            }
        });
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initReplyManager() {
        if (!this.started.get()) {
            this.lock.lock();
            try {
                if (this.started.get()) {
                    return;
                }
                LOG.debug("Starting reply manager");
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                ClassLoader ac = this.getEndpoint().getCamelContext().getApplicationContextClassLoader();
                try {
                    if (ac != null) {
                        Thread.currentThread().setContextClassLoader(ac);
                    }
                    if (this.getEndpoint().getReplyToTopic() != null) {
                        this.replyManager = this.createReplyManager();
                        LOG.debug("Using RocketMQReplyManager: {} to process replies from topic {}", (Object)this.replyManager, (Object)this.getEndpoint().getReplyToTopic());
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.getEndpoint(), (Throwable)e);
                }
                finally {
                    if (ac != null) {
                        Thread.currentThread().setContextClassLoader(current);
                    }
                }
                this.started.set(true);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void unInitReplyManager() {
        try {
            if (this.replyManager != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stopping RocketMQReplyManager: {} from processing replies from : {}", (Object)this.replyManager, (Object)this.getEndpoint().getReplyToTopic());
                }
                ServiceHelper.stopService((Object)this.replyManager);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            this.started.set(false);
        }
    }

    private ReplyManager createReplyManager() {
        RocketMQReplyManagerSupport replyManager = new RocketMQReplyManagerSupport(this.getEndpoint().getCamelContext());
        replyManager.setEndpoint(this.getEndpoint());
        String name = "RocketMQReplyManagerTimeoutChecker[" + this.getEndpoint().getTopicName() + "]";
        ScheduledExecutorService scheduledExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, name);
        replyManager.setScheduledExecutorService(scheduledExecutorService);
        LOG.debug("Starting ReplyManager: {}", (Object)name);
        ServiceHelper.startService((Service)replyManager);
        return replyManager;
    }

    protected boolean processInOnly(final Exchange exchange, final AsyncCallback callback) throws NoTypeConversionAvailableException, InterruptedException, RemotingException, MQClientException {
        Message in = exchange.getIn();
        org.apache.rocketmq.common.message.Message message = new org.apache.rocketmq.common.message.Message();
        message.setTopic((String)in.getHeader("CamelRockerMQOverrideTopicName", () -> this.getEndpoint().getTopicName(), String.class));
        message.setTags((String)in.getHeader("CamelRockerMQOverrideTag", () -> this.getEndpoint().getSendTag(), String.class));
        message.setBody((byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, in.getBody()));
        message.setKeys((String)in.getHeader("CamelRockerMQOverrideMessageKey", (Object)"", String.class));
        LOG.debug("RocketMQ Producer sending {}", (Object)message);
        final boolean waitForSendResult = this.getEndpoint().isWaitForSendResult();
        this.mqProducer.send(message, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                if (!SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus())) {
                    exchange.setException((Throwable)new SendFailedException(sendResult.toString()));
                }
                callback.done(!waitForSendResult);
            }

            public void onException(Throwable e) {
                exchange.setException(e);
                callback.done(!waitForSendResult);
            }
        });
        return !waitForSendResult;
    }

    protected void doStart() throws Exception {
        this.mqProducer = new DefaultMQProducer(this.getEndpoint().getProducerGroup(), RocketMQAclUtils.getAclRPCHook(this.getEndpoint().getAccessKey(), this.getEndpoint().getSecretKey()));
        this.mqProducer.setNamesrvAddr(this.getEndpoint().getNamesrvAddr());
        this.mqProducer.setNamespaceV2(this.getEndpoint().getNamespace());
        this.mqProducer.setEnableTrace(this.getEndpoint().isEnableTrace());
        this.mqProducer.setAccessChannel(AccessChannel.valueOf((String)this.getEndpoint().getAccessChannel()));
        this.mqProducer.start();
    }

    protected void doStop() {
        this.unInitReplyManager();
        this.mqProducer.shutdown();
        this.mqProducer = null;
    }
}

