/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq.reply;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.rocketmq.reply.ReplyHandler;
import org.apache.camel.support.DefaultTimeoutMap;

public class ReplyTimeoutMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    public ReplyTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        super(executor, requestMapPollTimeMillis);
        this.addListener(this::listener);
    }

    private static long encode(long timeoutMillis) {
        return timeoutMillis > 0L ? timeoutMillis : Integer.MAX_VALUE;
    }

    private void listener(TimeoutMap.Listener.Type type, String key, ReplyHandler handler) {
        switch (type) {
            case Put: {
                this.log.trace("Added messageKey: {}", (Object)key);
                break;
            }
            case Remove: {
                this.log.trace("Removed messageKey: {}", (Object)key);
                break;
            }
            case Evict: {
                try {
                    handler.onTimeout(key);
                }
                catch (Exception e) {
                    this.log.warn("Error processing onTimeout for messageKey: {} due: {}. This exception is ignored.", new Object[]{key, e.getLocalizedMessage(), e});
                }
                this.log.trace("Evicted messageKey: {}", (Object)key);
                break;
            }
        }
    }

    public ReplyHandler put(String key, ReplyHandler value, long timeoutMillis) {
        return (ReplyHandler)super.put((Object)key, (Object)value, ReplyTimeoutMap.encode(timeoutMillis));
    }

    public ReplyHandler putIfAbsent(String key, ReplyHandler value, long timeoutMillis) {
        return (ReplyHandler)super.putIfAbsent((Object)key, (Object)value, ReplyTimeoutMap.encode(timeoutMillis));
    }
}

