/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslYamlGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.maven.generator.openapi.AbstractGenerateMojo;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-yaml", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateYamlMojo
extends AbstractGenerateMojo {
    @Parameter(defaultValue="camel-rest.yaml", required=true)
    private String fileName;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/restdsl-openapi", required=true)
    private String outputDirectory;

    public void execute() throws MojoExecutionException {
        this.execute(false);
    }

    protected void execute(boolean dto) throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        OpenAPI openapi = new OpenAPIV3Parser().read(this.specificationUri);
        if (openapi == null) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri + ", make sure that the specification is available at the given URI");
        }
        RestDslYamlGenerator generator = RestDslGenerator.toYaml((OpenAPI)openapi);
        if (ObjectHelper.isNotEmpty((String)this.basePath)) {
            generator.withBasePath(this.basePath);
        }
        if (ObjectHelper.isNotEmpty((String)this.filterOperation)) {
            generator.withOperationFilter(this.filterOperation);
        }
        if (dto && this.modelPackage != null) {
            generator.withDtoPackageName(this.modelPackage);
        }
        if (ObjectHelper.isNotEmpty((String)this.destinationGenerator)) {
            DestinationGenerator destinationGeneratorObject = this.createDestinationGenerator();
            generator.withDestinationGenerator(destinationGeneratorObject);
        } else if (ObjectHelper.isNotEmpty((String)this.destinationToSyntax)) {
            generator.withDestinationToSyntax(this.destinationToSyntax);
        }
        if (this.restConfiguration) {
            generator.withRestComponent(this.findAppropriateComponent());
            if (this.clientRequestValidation) {
                generator.withClientRequestValidation();
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                generator.withApiContextPath(this.apiContextPath);
            }
        }
        try {
            DefaultCamelContext camel = new DefaultCamelContext();
            String yaml = generator.generate((CamelContext)camel);
            new File(this.outputDirectory).mkdirs();
            File out = new File(this.outputDirectory, this.fileName);
            try (FileOutputStream fos = new FileOutputStream(out);){
                fos.write(yaml.getBytes());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri, e);
        }
    }
}

