/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.Tag;

abstract class AbstractGenerateMojo
extends AbstractMojo {
    public static final String[] DEFAULT_REST_CONSUMER_COMPONENTS = new String[]{"platform-http", "servlet", "jetty", "undertow", "netty-http", "coap"};
    @Parameter
    String apiContextPath;
    @Parameter
    String destinationGenerator;
    @Parameter
    String destinationToSyntax;
    @Parameter
    String filterOperation;
    @Parameter
    String modelNamePrefix;
    @Parameter
    String modelNameSuffix;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/openapi")
    String modelOutput;
    @Parameter
    String modelPackage;
    @Parameter(defaultValue="false")
    String modelWithXml;
    @Parameter(defaultValue="${project}")
    MavenProject project;
    @Parameter(defaultValue="true")
    boolean restConfiguration;
    @Parameter(defaultValue="false")
    boolean clientRequestValidation;
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="${project.basedir}/src/spec/openapi.json", required=true)
    String specificationUri;
    @Parameter(name="auth")
    String auth;
    @Parameter
    String basePath;
    @Parameter(defaultValue="3.0.54")
    String swaggerCodegenMavenPluginVersion;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter
    private Map<String, String> configOptions;

    AbstractGenerateMojo() {
    }

    DestinationGenerator createDestinationGenerator() throws MojoExecutionException {
        DestinationGenerator destinationGeneratorObject;
        Class<?> destinationGeneratorClass;
        URL outputDirectory;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            outputDirectory = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        URL[] withOutput = new URL[]{outputDirectory};
        try (URLClassLoader classLoader = new URLClassLoader(withOutput, contextClassLoader);){
            Class<?> tmp = classLoader.loadClass(this.destinationGenerator);
            if (!DestinationGenerator.class.isAssignableFrom(tmp)) {
                throw new MojoExecutionException("The given destinationGenerator class (" + this.destinationGenerator + ") does not implement " + DestinationGenerator.class.getName() + " interface.");
            }
            destinationGeneratorClass = tmp;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MojoExecutionException("The given destinationGenerator class (" + this.destinationGenerator + ") cannot be loaded, make sure that it is present in the COMPILE classpath scope of the project", e);
        }
        try {
            destinationGeneratorObject = (DestinationGenerator)destinationGeneratorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MojoExecutionException("The given destinationGenerator class (" + this.destinationGenerator + ") cannot be instantiated, make sure that it is declared as public and that all dependencies are present on the COMPILE classpath scope of the project", (Exception)e);
        }
        return destinationGeneratorObject;
    }

    void generateDto(String language) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating DTO classes using io.swagger.codegen.v3:swagger-codegen-maven-plugin:" + this.swaggerCodegenMavenPluginVersion));
        ArrayList<MojoExecutor.Element> elements = new ArrayList<MojoExecutor.Element>();
        elements.add(new MojoExecutor.Element("inputSpec", this.specificationUri, new MojoExecutor.Element[0]));
        elements.add(new MojoExecutor.Element("language", language, new MojoExecutor.Element[0]));
        elements.add(new MojoExecutor.Element("generateApis", "false", new MojoExecutor.Element[0]));
        elements.add(new MojoExecutor.Element("generateModelTests", "false", new MojoExecutor.Element[0]));
        elements.add(new MojoExecutor.Element("generateModelDocumentation", "false", new MojoExecutor.Element[0]));
        elements.add(new MojoExecutor.Element("generateSupportingFiles", "false", new MojoExecutor.Element[0]));
        if (this.modelOutput != null) {
            elements.add(new MojoExecutor.Element("output", this.modelOutput, new MojoExecutor.Element[0]));
        }
        if (this.modelPackage != null) {
            elements.add(new MojoExecutor.Element("modelPackage", this.modelPackage, new MojoExecutor.Element[0]));
        }
        if (this.modelNamePrefix != null) {
            elements.add(new MojoExecutor.Element("modelNamePrefix", this.modelNamePrefix, new MojoExecutor.Element[0]));
        }
        if (this.modelNameSuffix != null) {
            elements.add(new MojoExecutor.Element("modelNameSuffix", this.modelNameSuffix, new MojoExecutor.Element[0]));
        }
        if (this.modelWithXml != null) {
            elements.add(new MojoExecutor.Element("withXml", this.modelWithXml, new MojoExecutor.Element[0]));
        }
        if (this.configOptions == null) {
            this.configOptions = new HashMap<String, String>(1);
        }
        this.configOptions.put("hideGenerationTimestamp", "true");
        elements.add(new MojoExecutor.Element("configOptions", (MojoExecutor.Element[])this.configOptions.entrySet().stream().map(e -> new MojoExecutor.Element((String)e.getKey(), (String)e.getValue(), new MojoExecutor.Element[0])).toArray(MojoExecutor.Element[]::new)));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"io.swagger.codegen.v3"), (String)MojoExecutor.artifactId((String)"swagger-codegen-maven-plugin"), (String)MojoExecutor.version((String)this.swaggerCodegenMavenPluginVersion)), (String)MojoExecutor.goal((String)"generate"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])elements.toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    protected String detectCamelVersionFromClasspath() {
        return this.mavenProject.getDependencies().stream().filter(d -> "org.apache.camel".equals(d.getGroupId()) && ObjectHelper.isNotEmpty((String)d.getVersion())).findFirst().map(Dependency::getVersion).orElse(null);
    }

    protected String detectRestComponentFromClasspath() {
        for (Dependency dep : this.mavenProject.getDependencies()) {
            if (!"org.apache.camel".equals(dep.getGroupId()) && !"org.apache.camel.springboot".equals(dep.getGroupId())) continue;
            String aid = dep.getArtifactId();
            Optional<String> comp = Arrays.stream(DEFAULT_REST_CONSUMER_COMPONENTS).filter(c -> aid.startsWith("camel-" + c)).findFirst();
            if (!comp.isPresent()) continue;
            return comp.get();
        }
        return null;
    }

    protected boolean detectSpringBootFromClasspath() {
        return this.mavenProject.getDependencies().stream().anyMatch(d -> "org.springframework.boot".equals(d.getGroupId()));
    }

    protected String detectSpringBootMainPackage() throws IOException {
        for (String src : this.mavenProject.getCompileSourceRoots()) {
            String d = this.findSpringSpringBootPackage(new File(src));
            if (d == null) continue;
            return d;
        }
        return null;
    }

    protected String findSpringSpringBootPackage(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String packageName;
                if (file.getName().endsWith(".java")) {
                    try (FileInputStream stream = new FileInputStream(file);){
                        String content = IOHelper.loadText((InputStream)stream);
                        if (!content.contains("@SpringBootApplication")) continue;
                        String string = AbstractGenerateMojo.grabPackageName(content);
                        return string;
                    }
                }
                if (!file.isDirectory() || (packageName = this.findSpringSpringBootPackage(file)) == null) continue;
                return packageName;
            }
        }
        return null;
    }

    protected static String grabPackageName(String content) {
        String[] lines;
        for (String line : lines = content.split("\\n")) {
            if (!(line = line.trim()).startsWith("package ")) continue;
            line = line.substring(8);
            if ((line = line.trim()).endsWith(";")) {
                line = line.substring(0, line.length() - 1);
            }
            return line;
        }
        return null;
    }

    protected String findAppropriateComponent() {
        String comp = this.detectRestComponentFromClasspath();
        if (comp != null) {
            this.getLog().info((CharSequence)("Detected Camel Rest component from classpath: " + comp));
        } else {
            comp = "platform-http";
            String gid = "org.apache.camel";
            String aid = "camel-platform-http";
            if (this.detectSpringBootFromClasspath()) {
                gid = "org.apache.camel.springboot";
                aid = "camel-platform-http-starter";
            }
            String dep = "\n\t\t<dependency>\n\t\t\t<groupId>" + gid + "</groupId>\n\t\t\t<artifactId>" + aid + "</artifactId>";
            String ver = this.detectCamelVersionFromClasspath();
            if (ver != null) {
                dep = dep + "\n\t\t\t<version>" + ver + "</version>";
            }
            dep = dep + "\n\t\t</dependency>\n";
            this.getLog().info((CharSequence)"Cannot detect Rest component from classpath. Will use platform-http as Rest component.");
            this.getLog().info((CharSequence)("Add the following dependency in the Maven pom.xml file:\n" + dep + "\n"));
        }
        return comp;
    }

    private URL inputSpecRemoteUrl(String specificationUri) {
        try {
            return new URI(specificationUri).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    private Map<String, String> parse(String urlEncodedAuthStr) {
        HashMap<String, String> auths = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)urlEncodedAuthStr)) {
            String[] parts;
            for (String part : parts = urlEncodedAuthStr.split(",")) {
                String[] kvPair = part.split(":");
                if (kvPair.length != 2) continue;
                auths.put(URLDecoder.decode(kvPair[0], StandardCharsets.UTF_8), URLDecoder.decode(kvPair[1], StandardCharsets.UTF_8));
            }
        }
        return auths;
    }

    final class TrustedTagInspector
    implements TagInspector {
        TrustedTagInspector() {
        }

        public boolean isGlobalTagAllowed(Tag tag) {
            return true;
        }
    }
}

