/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestOpenapiProcessorStrategy
extends ServiceSupport
implements RestOpenapiProcessorStrategy,
CamelContextAware,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestOpenapiProcessorStrategy.class);
    private CamelContext camelContext;
    private ProducerCache producerCache;
    private String component = "direct";
    private String missingOperation;
    private String mockIncludePattern;
    private final List<String> uris = new ArrayList<String>();

    @Override
    public void validateOpenApi(OpenAPI openAPI, PlatformHttpConsumerAware platformHttpConsumer) throws Exception {
        PlatformHttpComponent phc;
        ArrayList<CallSite> ids = new ArrayList<CallSite>();
        for (Object e : openAPI.getPaths().entrySet()) {
            for (Operation o : ((PathItem)e.getValue()).readOperations()) {
                String id2 = o.getOperationId();
                ids.add((CallSite)((Object)(this.component + "://" + id2)));
            }
        }
        ArrayList<String> existing = new ArrayList<String>();
        for (Route route : this.camelContext.getRoutes()) {
            String base = route.getEndpoint().getEndpointBaseUri();
            existing.add(base);
        }
        ids.removeAll(existing);
        if (!ids.isEmpty()) {
            String missing = ids.stream().sorted().map(id -> id.replace("://", ":")).collect(Collectors.joining("\n\t"));
            String msg = String.format("OpenAPI specification has %d unmapped operations to corresponding routes: %n\t%s", ids.size(), missing);
            if ("fail".equalsIgnoreCase(this.missingOperation)) {
                throw new IllegalArgumentException(msg);
            }
            if ("ignore".equalsIgnoreCase(this.missingOperation)) {
                LOG.warn(msg + "\nThis validation error is ignored.");
            } else if ("mock".equalsIgnoreCase(this.missingOperation)) {
                LOG.debug(msg + "\nThis validation error is ignored (Will return a mocked/empty response).");
            }
        }
        if ((phc = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class)) != null) {
            String path = RestOpenApiHelper.getBasePathFromOpenApi(openAPI);
            if (path == null || path.isEmpty() || path.equals("/")) {
                path = "";
            }
            for (Map.Entry p : openAPI.getPaths().entrySet()) {
                String uri = path + (String)p.getKey();
                String verbs = ((PathItem)p.getValue()).readOperationsMap().keySet().stream().map(Enum::name).sorted().collect(Collectors.joining(","));
                String consumes = null;
                String produces = null;
                for (Operation o : ((PathItem)p.getValue()).readOperations()) {
                    Content c;
                    if (o.getRequestBody() != null && (c = o.getRequestBody().getContent()) != null) {
                        consumes = c.keySet().stream().sorted().collect(Collectors.joining(","));
                    }
                    if (o.getResponses() == null) continue;
                    for (ApiResponse a : o.getResponses().values()) {
                        Content c2 = a.getContent();
                        if (c2 == null) continue;
                        produces = c2.keySet().stream().sorted().collect(Collectors.joining(","));
                    }
                }
                phc.addHttpEndpoint(uri, verbs, consumes, produces, (Consumer)platformHttpConsumer.getPlatformHttpConsumer());
                this.uris.add(uri);
            }
        }
    }

    @Override
    public boolean processApiSpecification(String specificationUri, Exchange exchange, AsyncCallback callback) {
        try {
            Resource res = PluginHelper.getResourceLoader((CamelContext)this.camelContext).resolveResource(specificationUri);
            if (res != null && res.exists()) {
                if (specificationUri.endsWith("json")) {
                    exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
                } else if (specificationUri.endsWith("yaml") || specificationUri.endsWith("yml")) {
                    exchange.getMessage().setHeader("Content-Type", (Object)"text/yaml");
                }
                InputStream is = res.getInputStream();
                String data = IOHelper.loadText((InputStream)is);
                exchange.getMessage().setBody((Object)data);
                IOHelper.close((Closeable)is);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    @Override
    public boolean process(Operation operation, String path, RestBindingAdvice binding, Exchange exchange, AsyncCallback callback) {
        Map state;
        Endpoint e;
        if (("mock".equalsIgnoreCase(this.missingOperation) || "ignore".equalsIgnoreCase(this.missingOperation)) && (e = this.camelContext.hasEndpoint(this.component + ":" + operation.getOperationId())) == null) {
            if ("mock".equalsIgnoreCase(this.missingOperation)) {
                this.loadMockData(operation, path, exchange);
            }
            callback.done(true);
            return true;
        }
        try {
            state = binding.before(exchange);
        }
        catch (Exception e2) {
            exchange.setException((Throwable)e2);
            callback.done(true);
            return true;
        }
        Endpoint e3 = this.camelContext.getEndpoint(this.component + ":" + operation.getOperationId());
        AsyncProducer p = this.producerCache.acquireProducer(e3);
        return p.process(exchange, doneSync -> {
            try {
                this.producerCache.releaseProducer(e3, p);
                binding.after(exchange, state);
            }
            catch (Exception ex) {
                exchange.setException((Throwable)ex);
            }
            finally {
                callback.done(doneSync);
            }
        });
    }

    private void loadMockData(Operation operation, String path, Exchange exchange) {
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)this.camelContext);
        String[] includes = this.mockIncludePattern != null ? this.mockIncludePattern.split(",") : null;
        boolean json = false;
        boolean xml = false;
        Resource found = null;
        if (includes != null) {
            ArrayList accepted = new ArrayList();
            for (String include : includes) {
                try {
                    accepted.addAll(resolver.findResources(include));
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            }
            String ct = ExchangeHelper.getContentType((Exchange)exchange);
            if (ct != null) {
                json = ct.contains("json");
                xml = ct.contains("xml");
            }
            for (Resource resource : accepted) {
                boolean matchExt;
                String target = FileUtil.stripFirstLeadingSeparator((String)path);
                String loc = FileUtil.stripExt((String)FileUtil.compactPath((String)resource.getLocation(), (char)'/'));
                String onlyExt = FileUtil.onlyExt((String)resource.getLocation());
                boolean match = loc.endsWith(target);
                boolean bl = matchExt = !json && !xml || json && onlyExt.equals("json") || xml && onlyExt.equals("xml");
                if (!match || !matchExt) continue;
                found = resource;
                json = onlyExt.equals("json");
                xml = onlyExt.equals("xml");
                break;
            }
        }
        if (found != null) {
            try {
                if (json) {
                    exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
                } else if (xml) {
                    exchange.getMessage().setHeader("Content-Type", (Object)"text/xml");
                }
                exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)200);
                exchange.getMessage().setBody((Object)IOHelper.loadText((InputStream)found.getInputStream()));
            }
            catch (Exception exception) {}
        } else {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)204);
            exchange.getMessage().setBody((Object)"");
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    @Override
    public String getMissingOperation() {
        return this.missingOperation;
    }

    @Override
    public void setMissingOperation(String missingOperation) {
        this.missingOperation = missingOperation;
    }

    @Override
    public String getMockIncludePattern() {
        return this.mockIncludePattern;
    }

    @Override
    public void setMockIncludePattern(String mockIncludePattern) {
        this.mockIncludePattern = mockIncludePattern;
    }

    protected void doInit() throws Exception {
        this.producerCache = new DefaultProducerCache((Object)this, this.getCamelContext(), 1000);
        ServiceHelper.initService((Object)this.producerCache);
        if (this.missingOperation == null) {
            boolean dev = "dev".equalsIgnoreCase(this.camelContext.getCamelContextExtension().getProfile());
            this.missingOperation = dev ? "mock" : "fail";
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.producerCache);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.producerCache);
        PlatformHttpComponent phc = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        if (phc != null) {
            this.uris.forEach(arg_0 -> ((PlatformHttpComponent)phc).removeHttpEndpoint(arg_0));
            this.uris.clear();
        }
    }
}

