/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.util.ObjectHelper;

public class RestOpenApiOperation {
    private final Operation operation;
    private final String method;
    private final String uriTemplate;
    private final Set<Parameter> queryParams;
    private final Set<Parameter> formParams;
    private final Set<Parameter> headers;

    public RestOpenApiOperation(Operation operation, String method, String uriTemplate) {
        this.operation = operation;
        this.method = method;
        this.uriTemplate = uriTemplate;
        this.queryParams = this.resolveParametersForType("query");
        this.formParams = this.resolveParametersForType("form");
        this.headers = this.resolveParametersForType("header");
    }

    public Object getOperation() {
        return this.operation;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public Set<Parameter> getQueryParams() {
        return this.queryParams;
    }

    public Set<Parameter> getFormParams() {
        return this.formParams;
    }

    public Set<Parameter> getHeaders() {
        return this.headers;
    }

    private Set<Parameter> resolveParametersForType(String type) {
        List parameters = this.operation.getParameters();
        if (ObjectHelper.isEmpty((Collection)parameters)) {
            return Collections.emptySet();
        }
        return parameters.stream().filter(parameter -> type.equals(parameter.getIn())).collect(Collectors.toUnmodifiableSet());
    }
}

